/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.request;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import org.gcube.common.gxrest.request.GXConnection;
import org.gcube.common.gxrest.request.GXHTTP;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GXHTTPRequest
implements GXHTTP {
    private static final Logger logger = LoggerFactory.getLogger(GXHTTPRequest.class);
    private final GXConnection connection;

    private GXHTTPRequest(String address) {
        this.connection = new GXConnection(address);
    }

    public static GXHTTPRequest newRequest(String address) {
        GXHTTPRequest request = new GXHTTPRequest(address);
        return request;
    }

    public GXHTTPRequest from(String agent) {
        this.connection.setAgent(agent);
        return this;
    }

    public GXHTTPRequest path(String path) throws UnsupportedEncodingException {
        this.connection.addPath(path);
        return this;
    }

    public GXHTTPRequest withBody(String body) {
        this.connection.addBody(body);
        return this;
    }

    public GXHTTPRequest queryParams(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (Objects.nonNull(parameters) && !parameters.isEmpty()) {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (String key : parameters.keySet()) {
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(key, "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(parameters.get(key), "UTF-8"));
            }
            this.connection.setQueryParameters(result.toString());
        }
        return this;
    }

    public GXHTTPRequest setSecurityToken(String token) {
        this.connection.setProperty("gcube-token", token);
        return this;
    }

    @Override
    public GXInboundResponse post() throws Exception {
        logger.trace("Sending a POST request...");
        return this.connection.send(GXConnection.HTTPMETHOD.POST);
    }

    @Override
    public GXInboundResponse get() throws Exception {
        logger.trace("Sending a GET request...");
        return this.connection.send(GXConnection.HTTPMETHOD.GET);
    }

    @Override
    public GXInboundResponse put() throws Exception {
        logger.trace("Sending a PUT request...");
        return this.connection.send(GXConnection.HTTPMETHOD.PUT);
    }

    @Override
    public GXInboundResponse delete() throws Exception {
        logger.trace("Sending a DELETE request...");
        return this.connection.send(GXConnection.HTTPMETHOD.DELETE);
    }

    @Override
    public GXInboundResponse head() throws Exception {
        logger.trace("Sending a HEAD request...");
        return this.connection.send(GXConnection.HTTPMETHOD.HEAD);
    }

    public void clear() {
        this.connection.reset();
    }
}

