/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.response.inbound;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import org.gcube.common.gxrest.response.entity.SerializableErrorEntity;
import org.gcube.common.gxrest.response.inbound.ContentUtils;
import org.gcube.common.gxrest.response.inbound.ErrorCodeDeserializer;
import org.gcube.common.gxrest.response.inbound.ExceptionDeserializer;
import org.gcube.common.gxrest.response.outbound.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GXInboundResponse {
    private SerializableErrorEntity entity;
    private final int responseCode;
    private String contentType;
    private String message;
    private String body;
    private byte[] streamedContent;
    private Map<String, List<String>> headerFields;
    private static final Logger logger = LoggerFactory.getLogger(GXInboundResponse.class);
    private boolean hasGXError = false;

    public GXInboundResponse(Response source) {
        this.responseCode = source.getStatusInfo().getStatusCode();
        this.headerFields = source.getStringHeaders();
        this.contentType = source.getMediaType().getType();
        try {
            if (Objects.nonNull(source.getEntityTag()) && source.getEntityTag().getValue().equals("GXErrorResponse")) {
                this.entity = (SerializableErrorEntity)source.readEntity(SerializableErrorEntity.class);
                this.hasGXError = true;
            } else {
                this.body = (String)source.readEntity(String.class);
            }
        }
        catch (IllegalStateException | ProcessingException ie) {
            this.message = (String)source.getEntity();
        }
    }

    public GXInboundResponse(HttpURLConnection connection) throws IOException {
        this.responseCode = connection.getResponseCode();
        this.headerFields = connection.getHeaderFields();
        this.contentType = connection.getContentType();
        String eTag = connection.getHeaderField("ETag");
        if (Objects.nonNull(eTag) && eTag.replaceAll("^\"|\"$", "").equals("GXErrorResponse")) {
            logger.debug("GXErrorResponse detected.");
            this.hasGXError = true;
            try {
                this.streamedContent = ContentUtils.toByteArray(connection.getErrorStream());
                this.body = ContentUtils.toString(this.streamedContent);
                this.entity = ContentUtils.fromJson(this.body, SerializableErrorEntity.class);
                logger.trace("Response's content: " + this.body);
            }
            catch (Exception ioe) {
                logger.warn("No data are available in the response.");
            }
        } else {
            try {
                this.streamedContent = ContentUtils.toByteArray(connection.getInputStream());
                if (this.contentType.equals("text/plain") || this.contentType.equals("application/json")) {
                    this.body = ContentUtils.toString(this.streamedContent);
                    logger.trace("Response's content: " + this.body);
                }
            }
            catch (Exception ioe) {
                logger.warn("No data are available in the response.", (Throwable)ioe);
            }
        }
    }

    public boolean hasException() {
        return Objects.nonNull(this.entity) && Objects.nonNull(this.entity.getExceptionClass());
    }

    public boolean hasGXError() {
        return this.hasGXError;
    }

    public <E extends Exception> E getException() throws ClassNotFoundException {
        if (Objects.nonNull(this.entity)) {
            Object e = ExceptionDeserializer.deserialize(this.entity.getExceptionClass(), this.entity.getMessage());
            if (Objects.nonNull(e)) {
                if (this.entity.hasStackTrace()) {
                    ExceptionDeserializer.addStackTrace(e, this.entity.getEncodedTrace());
                } else {
                    ((Throwable)e).setStackTrace(new StackTraceElement[0]);
                }
                return e;
            }
            throw new ClassNotFoundException("Failed to deserialize: " + this.entity.getExceptionClass() + ". Not on the classpath?");
        }
        return null;
    }

    public boolean hasErrorCode() {
        if (Objects.nonNull(this.entity)) {
            return this.entity.getId() != -1;
        }
        return false;
    }

    public ErrorCode getErrorCode() {
        if (Objects.nonNull(this.entity)) {
            return ErrorCodeDeserializer.deserialize(this.entity.getId(), this.entity.getMessage());
        }
        return null;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStreamedContentAsString() {
        return this.body;
    }

    public byte[] getStreamedContent() {
        return this.streamedContent;
    }

    public <T> T tryConvertStreamedContentFromJson(Class<T> raw) throws Exception {
        return ContentUtils.fromJson(this.body, raw);
    }

    public int getHTTPCode() {
        return this.responseCode;
    }

    public boolean hasCREATEDCode() {
        return this.getHTTPCode() == Response.Status.CREATED.getStatusCode();
    }

    public boolean hasOKCode() {
        return this.getHTTPCode() == Response.Status.OK.getStatusCode();
    }

    public boolean hasNOT_ACCEPTABLECode() {
        return this.getHTTPCode() == Response.Status.NOT_ACCEPTABLE.getStatusCode();
    }

    public boolean hasBAD_REQUESTCode() {
        return this.getHTTPCode() == Response.Status.BAD_REQUEST.getStatusCode();
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }
}

