package org.gcube.common.gxrest.request;

import java.io.InputStream;
import java.util.Objects;

import org.gcube.common.gxrest.request.GXConnection.HTTPMETHOD;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;

/**
 * A context-aware request to a web application.
 * It supports sending streams through Put/Post requests.
 *  
 * @author Manuele Simi (ISTI CNR)
 *
 */
public class GXHTTPStreamRequest extends GXHTTPCommon<GXHTTPStreamRequest> implements GXHTTP<InputStream> {

	/**
	 * A new request.
	 */
	private GXHTTPStreamRequest(String address) {
		this.connection = new GXConnection(address);
	}

	/**
	 * Creates a new request.
	 * 
	 * @param address
	 *            the address of the web app to call
	 * @return the request
	 */
	public static GXHTTPStreamRequest newRequest(String address) {
		return new GXHTTPStreamRequest(address);
	}
	/* (non-Javadoc)
	 * @see org.gcube.common.gxrest.request.GXHTTP#put(java.lang.Object)
	 */
	@Override
	public GXInboundResponse put(InputStream body) throws Exception {
		if (Objects.nonNull(body))
			this.connection.addBodyAsStream(body);
		logger.trace("Sending a PUT request...");
		return this.connection.send(HTTPMETHOD.PUT);
	}

	/* (non-Javadoc)
	 * @see org.gcube.common.gxrest.request.GXHTTP#post(java.lang.Object)
	 */
	@Override
	public GXInboundResponse post(InputStream body) throws Exception {
		logger.trace("Sending a POST request...");
		if (Objects.nonNull(body))
			this.connection.addBodyAsStream(body);
		return this.connection.send(HTTPMETHOD.POST);
	}

}
