/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.request;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import org.gcube.common.gxrest.request.GXConnection;
import org.gcube.common.gxrest.request.GXHTTPStringRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class GXHTTPCommon<REQUEST> {
    protected static final Logger logger = LoggerFactory.getLogger(GXHTTPStringRequest.class);
    protected GXConnection connection;

    GXHTTPCommon() {
    }

    public REQUEST from(String agent) {
        this.connection.setAgent(agent);
        return (REQUEST)this;
    }

    public REQUEST path(String path) throws UnsupportedEncodingException {
        this.connection.addPath(path);
        return (REQUEST)this;
    }

    public REQUEST queryParams(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (Objects.nonNull(parameters) && !parameters.isEmpty()) {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(parameter.getKey(), "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(parameter.getValue(), "UTF-8"));
            }
            this.connection.setQueryParameters(result.toString());
        }
        return (REQUEST)this;
    }

    public void setSecurityToken(String token) {
        if (this.connection.isExtCall()) {
            throw new UnsupportedOperationException("Cannot set the security token on an external call");
        }
        this.connection.setProperty("gcube-token", token);
    }

    public REQUEST header(String name, String value) {
        this.connection.setProperty(name, value);
        return (REQUEST)this;
    }

    public GXInboundResponse put() throws Exception {
        logger.trace("Sending a PUT request...");
        return this.connection.send(GXConnection.HTTPMETHOD.PUT);
    }

    public GXInboundResponse post() throws Exception {
        logger.trace("Sending a POST request...");
        return this.connection.send(GXConnection.HTTPMETHOD.POST);
    }

    public GXInboundResponse get() throws Exception {
        logger.trace("Sending a GET request...");
        return this.connection.send(GXConnection.HTTPMETHOD.GET);
    }

    public GXInboundResponse delete() throws Exception {
        logger.trace("Sending a DELETE request...");
        return this.connection.send(GXConnection.HTTPMETHOD.DELETE);
    }

    public GXInboundResponse head() throws Exception {
        logger.trace("Sending a HEAD request...");
        return this.connection.send(GXConnection.HTTPMETHOD.HEAD);
    }

    public void clear() {
        this.connection.reset();
    }

    public GXInboundResponse trace() throws Exception {
        logger.trace("Sending a TRACE request...");
        return this.connection.send(GXConnection.HTTPMETHOD.TRACE);
    }

    public GXInboundResponse patch() throws Exception {
        logger.trace("Sending a TRACE request...");
        return this.connection.send(GXConnection.HTTPMETHOD.PATCH);
    }

    public GXInboundResponse options() throws Exception {
        logger.trace("Sending an OPTIONS request...");
        return this.connection.send(GXConnection.HTTPMETHOD.OPTIONS);
    }

    public GXInboundResponse connect() throws Exception {
        logger.trace("Sending a CONNECT request...");
        return this.connection.send(GXConnection.HTTPMETHOD.CONNECT);
    }

    public void isExternalCall(boolean ext) {
        this.connection.setExtCall(ext);
    }
}

