/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.request;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import org.gcube.common.gxrest.request.GXConnection;
import org.gcube.common.gxrest.request.GXHTTP;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GXHTTPRequest
implements GXHTTP<String> {
    private static final Logger logger = LoggerFactory.getLogger(GXHTTPRequest.class);
    private final GXConnection connection;

    private GXHTTPRequest(String address) {
        this.connection = new GXConnection(address);
    }

    public static GXHTTPRequest newRequest(String address) {
        GXHTTPRequest request = new GXHTTPRequest(address);
        return request;
    }

    public GXHTTPRequest from(String agent) {
        this.connection.setAgent(agent);
        return this;
    }

    public GXHTTPRequest path(String path) throws UnsupportedEncodingException {
        this.connection.addPath(path);
        return this;
    }

    public GXHTTPRequest withBody(String body) {
        this.connection.addBody(body);
        return this;
    }

    public GXHTTPRequest queryParams(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (Objects.nonNull(parameters) && !parameters.isEmpty()) {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(parameter.getKey(), "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(parameter.getValue(), "UTF-8"));
            }
            this.connection.setQueryParameters(result.toString());
        }
        return this;
    }

    @Override
    public void setSecurityToken(String token) {
        if (this.connection.isExtCall()) {
            throw new UnsupportedOperationException("Cannot set the security token on an external call");
        }
        this.connection.setProperty("gcube-token", token);
    }

    public GXHTTPRequest header(String name, String value) {
        this.connection.setProperty(name, value);
        return this;
    }

    @Override
    public GXInboundResponse get() throws Exception {
        logger.trace("Sending a GET request...");
        return this.connection.send(GXConnection.HTTPMETHOD.GET);
    }

    @Override
    public GXInboundResponse delete() throws Exception {
        logger.trace("Sending a DELETE request...");
        return this.connection.send(GXConnection.HTTPMETHOD.DELETE);
    }

    @Override
    public GXInboundResponse head() throws Exception {
        logger.trace("Sending a HEAD request...");
        return this.connection.send(GXConnection.HTTPMETHOD.HEAD);
    }

    public void clear() {
        this.connection.reset();
    }

    @Override
    public GXInboundResponse put(String body) throws Exception {
        if (Objects.nonNull(body)) {
            this.connection.addBody(body);
        }
        logger.trace("Sending a PUT request...");
        return this.connection.send(GXConnection.HTTPMETHOD.PUT);
    }

    @Override
    public GXInboundResponse put() throws Exception {
        logger.trace("Sending a PUT request...");
        return this.connection.send(GXConnection.HTTPMETHOD.PUT);
    }

    @Override
    public GXInboundResponse post() throws Exception {
        logger.trace("Sending a POST request...");
        return this.connection.send(GXConnection.HTTPMETHOD.POST);
    }

    @Override
    public GXInboundResponse post(String body) throws Exception {
        logger.trace("Sending a POST request...");
        if (Objects.nonNull(body)) {
            this.connection.addBody(body);
        }
        return this.connection.send(GXConnection.HTTPMETHOD.POST);
    }

    @Override
    public GXInboundResponse trace() throws Exception {
        logger.trace("Sending a TRACE request...");
        return this.connection.send(GXConnection.HTTPMETHOD.TRACE);
    }

    @Override
    public GXInboundResponse patch() throws Exception {
        logger.trace("Sending a TRACE request...");
        return this.connection.send(GXConnection.HTTPMETHOD.PATCH);
    }

    @Override
    public GXInboundResponse options() throws Exception {
        logger.trace("Sending an OPTIONS request...");
        return this.connection.send(GXConnection.HTTPMETHOD.OPTIONS);
    }

    @Override
    public GXInboundResponse connect() throws Exception {
        logger.trace("Sending a CONNECT request...");
        return this.connection.send(GXConnection.HTTPMETHOD.CONNECT);
    }

    @Override
    public void isExternalCall(boolean ext) {
        this.connection.setExtCall(ext);
    }
}

