package org.gcube.common.gxrest.request;

import java.util.Objects;

import org.gcube.common.gxrest.request.GXConnection.HTTPMETHOD;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;


/**
 * A context-aware request to a web application.
 * It supports sending strings through Put/Post requests.
 * 
 * @author Manuele Simi (ISTI-CNR)
 * @author Luca Frosini (ISTI-CNR)
 */
public class GXHTTPStringRequest extends GXHTTPCommon<GXHTTPStringRequest> implements GXHTTP<String> {


	/**
	 * A new request.
	 */
	private GXHTTPStringRequest(String address) {
		this.connection = new GXConnection(address);
	}

	/**
	 * Creates a new request.
	 * 
	 * @param address
	 *            the address of the web app to call
	 * @return the request
	 */
	public static GXHTTPStringRequest newRequest(String address) {
		return new GXHTTPStringRequest(address);
	}


	/**
	 * Sets the body of the request.
	 * 
	 * @param body
	 * @return the request
	 */
	public GXHTTPStringRequest withBody(String body) {
		this.connection.addBody(body);
		return this;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.gcube.common.gxrest.request.GXHTTP#put(java.lang.Object)
	 */
	@Override
	public GXInboundResponse put(String body) throws Exception {
		if (Objects.nonNull(body))
			this.connection.addBody(body);
		logger.trace("Sending a PUT request...");
		return this.connection.send(HTTPMETHOD.PUT);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.gcube.common.gxrest.request.GXHTTP#post()
	 */
	@Override
	public GXInboundResponse post(String body) throws Exception {
		logger.trace("Sending a POST request...");
		if (Objects.nonNull(body))
			this.connection.addBody(body);
		return this.connection.send(HTTPMETHOD.POST);
	}


}
