package org.gcube.dbinterface.h2;

import java.util.HashMap;
import java.util.Map;

import org.gcube.common.dbinterface.builders.Builders;
import org.gcube.common.dbinterface.queries.GetMetadata;
import org.gcube.common.dbinterface.registry.DBInterface;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type.InnerType;
import org.gcube.dbinterface.h2.builders.BuildersImpl;
import org.gcube.dbinterface.h2.query.GetMetadataImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBInterfaceImpl extends DBInterface {


	private static final Logger logger = LoggerFactory.getLogger(DBInterfaceImpl.class);
	
	Map<InnerType, String[]> typeMapping;
	
	@Override
	public void initialise() {
		logger.debug("initialisation method called");
		typeMapping = new HashMap<InnerType, String[]>();
		typeMapping.put(InnerType.INTEGER, new String[]{"integer","int","numeric","int4","serial" });
		typeMapping.put(InnerType.STRING, new String[]{"character varying","varchar"});
		typeMapping.put(InnerType.TEXT, new String[]{"text", "clob"});
		typeMapping.put(InnerType.FLOAT, new String[]{"decimal","double precision","bigdecimal","float4","real"});
		typeMapping.put(InnerType.LONG, new String[]{"bigint"});
		typeMapping.put(InnerType.DATE, new String[]{"date"});
		typeMapping.put(InnerType.TIME, new String[]{"time"});
		typeMapping.put(InnerType.TIMESTAMP, new String[]{"timestamp","timestamp without time zone"});
		typeMapping.put(InnerType.BOOLEAN, new String[]{"boolean","bool"});
		logger.debug("initialisation method finished");
	}

	@Override
	public Builders builders() {
		return BuildersImpl.get();
	}

	@Override
	public Map<InnerType, String[]> getTypeMapping() {
		return this.typeMapping;
	}

	@Override
	public String getDrivers() {
		return "org.h2.Driver";
	}

	@Override
	public GetMetadata getMetadata(Table table) {
		return new GetMetadataImpl(table);
	}

}
