package org.gcube.dbinterface.h2.builders;

import org.gcube.common.dbinterface.builders.AddColumnBuilder;
import org.gcube.common.dbinterface.builders.Builders;
import org.gcube.common.dbinterface.builders.CastBuilder;
import org.gcube.common.dbinterface.builders.ColumnDefinitionBuilder;
import org.gcube.common.dbinterface.builders.CreateTableBuilder;
import org.gcube.common.dbinterface.builders.DeleteBuilder;
import org.gcube.common.dbinterface.builders.DropColumnBuilder;
import org.gcube.common.dbinterface.builders.DropTableBuilder;
import org.gcube.common.dbinterface.builders.ForeignKeyBuilder;
import org.gcube.common.dbinterface.builders.ModifyColumnTypeBuilder;
import org.gcube.common.dbinterface.builders.RenameTableBuilder;
import org.gcube.common.dbinterface.builders.SelectBuilder;
import org.gcube.common.dbinterface.builders.UpdateBuilder;
import org.gcube.dbinterface.h2.query.CastImpl;
import org.gcube.dbinterface.h2.query.ColumnDefinitionImpl;
import org.gcube.dbinterface.h2.query.ForeignKeyImpl;
import org.gcube.dbinterface.h2.query.PreparedInsertImpl;
import org.gcube.dbinterface.h2.query.SelectImpl;
import org.gcube.dbinterface.h2.query.update.AddColumnImpl;
import org.gcube.dbinterface.h2.query.update.CreateTableImpl;
import org.gcube.dbinterface.h2.query.update.DeleteImpl;
import org.gcube.dbinterface.h2.query.update.DropColumnImpl;
import org.gcube.dbinterface.h2.query.update.DropTableImpl;
import org.gcube.dbinterface.h2.query.update.ModifyColumnTypeImpl;
import org.gcube.dbinterface.h2.query.update.RenameTableImpl;
import org.gcube.dbinterface.h2.query.update.UpdateImpl;

public class BuildersImpl extends Builders{

	private static Builders singleton = new BuildersImpl();
		
	private BuildersImpl(){}
			
	public static Builders get(){return singleton;}
	
	@Override
	public SelectBuilder select() {
		return new SelectBuilderImpl(new SelectImpl());
	}

	@Override
	public ColumnDefinitionBuilder columnDef() {
		return new ColumnBuilderImpl(new ColumnDefinitionImpl()); 
	}

	@Override
	public CreateTableBuilder createTable() {
		return new CreateTableBuilderImpl(new CreateTableImpl());
	}

	@Override
	public CastBuilder cast() {
		return new CastBuilderImpl(new CastImpl());
	}

	@Override
	public PreparedInsertBuilderImpl preparedInsert() {
		return new PreparedInsertBuilderImpl(new PreparedInsertImpl());
	}

	@Override
	public RenameTableBuilder renameTable() {
		return new RenameTableBuiderImpl(new RenameTableImpl());
	}

	@Override
	public DropTableBuilder dropTable() {
		return new DropTableBuilderImpl(new DropTableImpl());
	}

	@Override
	public DropColumnBuilder dropColumn() {
		return new DropColumnBuilderImpl(new DropColumnImpl());
	}

	@Override
	public ModifyColumnTypeBuilder modifyColumn() {
		return new ModifyColumnTypeBuilderImpl(new ModifyColumnTypeImpl());
	}

	@Override
	public AddColumnBuilder addColumn() {
		return new AddColumnBuilderImpl(new AddColumnImpl());
	}

	@Override
	public DeleteBuilder delete() {
		return new DeleteBuilderImpl(new DeleteImpl());
	}

	@Override
	public ForeignKeyBuilder foreignKey() {
		return new ForeignKeyBuilderImpl(new ForeignKeyImpl());
	}

	@Override
	public UpdateBuilder update() {
		return new UpdateBuilderImpl(new UpdateImpl());
	}

	
}
