package org.gcube.dbinterface.h2.query;

import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;

public class SelectImpl extends Select  {

	private String expression="SELECT <%DISTINCT%> <%ATTRIBUTES%> <%TABLE%> <%WHERE%> <%GROUPBY%> <%ORDER%> <%LIMIT%>  ";
	
	@Override
	public String getQuery() {
		return getExpression();
	}
	
	protected String getExpression(){
		String tmpExpression= new String(expression);
		
		tmpExpression= tmpExpression.replaceAll("<%DISTINCT%>", this._getDistinct());
		
		tmpExpression= tmpExpression.replaceAll("<%WHERE%>", this._getFilters());
		
		tmpExpression= tmpExpression.replaceAll("<%GROUPBY%>", this._getGroups());
		
		tmpExpression= tmpExpression.replaceAll("<%ATTRIBUTES%>", this._getAttributes());
		
		tmpExpression= tmpExpression.replaceAll("<%ORDER%>", this._getOrders());
		
		tmpExpression= tmpExpression.replaceAll("<%TABLE%>", this._getTables());
		
		tmpExpression= tmpExpression.replaceAll("<%LIMIT%>", this._getLimits());
						
		return tmpExpression;
	}
	
	protected String _getAttributes(){
		//resolving the attributes
		if ((this.getAttributes()==null) || (this.getAttributes().size()==0)) return "*";
		else {
			String tmpAttributes="";
			for (Attribute attribute: this.getAttributes())
				tmpAttributes+=attribute.getAttribute()+",";
			return tmpAttributes.substring(0, tmpAttributes.length()-1);
		}
	}
	
	protected String _getFilters(){
		//resolving the filters (where clause)
		if (this.getCondition()==null) return ""; 
		else 
			return "WHERE "+this.getCondition().getCondition();
	}
	
	protected String _getOrders(){
		//resolving the Orders
		String tmpOrder=" ";
		if (this.getOrderBy()==null || this.getOrderBy().size()==0) return "";
		else{
			tmpOrder="ORDER BY ";
			for (Order order: this.getOrderBy()){
				tmpOrder+=order.getOrder()+",";
			}
			return tmpOrder.substring(0, tmpOrder.length()-1);
		}
		
	}
	
	protected String _getTables(){
		//resolving the Tables
		if (this.getTables()==null || this.getTables().size()==0) return "";
		else{
			String tmpTables=" FROM ";
			for (Table table: this.getTables())
				tmpTables+=table.getTable()+",";
			return tmpTables.substring(0, tmpTables.length()-1);
		}
	}
	
	protected String _getLimits(){
		//resolving the Limits		
		if (this.getLimit()==null) return "";
		else return this.getLimit().getLimits();
	}
	
	protected String _getGroups(){
		//resolving the Tables
		if (this.getGroupBy()==null || this.getGroupBy().size()==0) return "";
		else{
			String tmpGroups="GROUP BY ";
			for (Attribute attrib: this.getGroupBy())
				tmpGroups+=attrib.getAttribute()+",";
			return tmpGroups.substring(0, tmpGroups.length()-1);
		}
	}
	
	protected String _getDistinct(){
		return this.isUseDistinct()?"DISTINCT":""; 
	}
	
}
