package org.gcube.dbinterface.h2.query.update;

import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.ForeignKey;
import org.gcube.common.dbinterface.queries.update.CreateTable;

public class CreateTableImpl extends CreateTable {

	private final String query= "CREATE TABLE <%NAME%> <%DEFINITION%>"; 
	
	
	@Override
	public String getUpdateQuery() {
		String toReturn = query.replace("<%NAME%>", getTableName());
		if (this.getSelection()==null){
			
			String tempDefinition ="";
			
			if (this.getColumnDefinitions().size()>0){
				for (ColumnDefinition columnDefinition: this.getColumnDefinitions())
					tempDefinition+=columnDefinition.getDefinition()+" ,";
				tempDefinition = (String) tempDefinition.subSequence(0, tempDefinition.length()-2);
			}

			for (ForeignKey foreignKey: getForeignKeys())
				tempDefinition+=" , "+foreignKey.getDefinition();

			return toReturn.replace("<%DEFINITION%>", "("+tempDefinition+")");
		}else
			return toReturn.replace("<%DEFINITION%>", " AS ("+getSelection().getQuery()+")");			
	}
	
}
