/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.health.api.response;

import java.util.ArrayList;
import org.gcube.common.health.api.Status;
import org.gcube.common.health.api.response.HealthCheckResponse;
import org.gcube.common.validator.ValidationError;
import org.gcube.common.validator.Validator;
import org.gcube.common.validator.ValidatorFactory;

public class HealthCheckResponseBuilder {
    private HealthCheckResponse healthCheckResponse = new HealthCheckResponse();

    protected HealthCheckResponseBuilder(String name) {
        this.healthCheckResponse.name = name;
    }

    public SuccessPart up() {
        this.healthCheckResponse.status = Status.UP;
        return new SuccessPart();
    }

    public ErrorPart down() {
        this.healthCheckResponse.status = Status.DOWN;
        return new ErrorPart();
    }

    private void validateResponse() {
        ArrayList<String> msgs = new ArrayList<String>();
        Validator validator = ValidatorFactory.validator();
        for (ValidationError error : validator.validate((Object)this.healthCheckResponse)) {
            msgs.add(error.toString());
        }
        if (!msgs.isEmpty()) {
            throw new IllegalStateException("invalid configuration: " + msgs);
        }
    }

    public class BuildPart {
        private BuildPart() {
        }

        public HealthCheckResponse build() {
            HealthCheckResponseBuilder.this.validateResponse();
            return HealthCheckResponseBuilder.this.healthCheckResponse;
        }
    }

    public class SuccessPart
    extends BuildPart {
        private SuccessPart() {
        }

        public BuildPart info(String info) {
            HealthCheckResponseBuilder.this.healthCheckResponse.info = info;
            return new BuildPart();
        }
    }

    public class ErrorPart {
        private ErrorPart() {
        }

        public BuildPart error(String message) {
            HealthCheckResponseBuilder.this.healthCheckResponse.errorMessage = message;
            return new BuildPart();
        }
    }
}

