/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Isolater {
    private static final Logger log = LoggerFactory.getLogger((Class)Isolater.class);

    public static void doIsolatedWork(IsolatedWork work, SessionImplementor session) throws HibernateException {
        boolean isJta;
        boolean bl = isJta = session.getFactory().getTransactionManager() != null;
        if (isJta) {
            new JtaDelegate(session).delegateWork(work, true);
        } else {
            new JdbcDelegate(session).delegateWork(work, true);
        }
    }

    public static void doNonTransactedWork(IsolatedWork work, SessionImplementor session) throws HibernateException {
        boolean isJta;
        boolean bl = isJta = session.getFactory().getTransactionManager() != null;
        if (isJta) {
            new JtaDelegate(session).delegateWork(work, false);
        } else {
            new JdbcDelegate(session).delegateWork(work, false);
        }
    }

    public static class JdbcDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JdbcDelegate(SessionImplementor session) {
            this.session = session;
        }

        /*
         * Loose catch block
         */
        public void delegateWork(IsolatedWork work, boolean transacted) throws HibernateException {
            block21: {
                boolean wasAutoCommit = false;
                try {
                    Exception ignore2;
                    Connection connection;
                    block20: {
                        block19: {
                            connection = this.session.getFactory().getConnectionProvider().getConnection();
                            if (transacted && connection.getAutoCommit()) {
                                wasAutoCommit = true;
                                connection.setAutoCommit(false);
                            }
                            work.doWork(connection);
                            if (!transacted) break block19;
                            connection.commit();
                        }
                        Object var8_6 = null;
                        if (!transacted || !wasAutoCommit) break block20;
                        try {
                            connection.setAutoCommit(true);
                        }
                        catch (Exception ignore2) {
                            log.trace("was unable to reset connection back to auto-commit");
                        }
                    }
                    try {
                        this.session.getFactory().getConnectionProvider().closeConnection(connection);
                    }
                    catch (Exception ignore2) {
                        log.info("Unable to release isolated connection [" + ignore2 + "]");
                    }
                    break block21;
                    {
                        catch (Exception e) {
                            try {
                                if (transacted && !connection.isClosed()) {
                                    connection.rollback();
                                }
                            }
                            catch (Exception ignore3) {
                                log.info("unable to rollback connection on exception [" + ignore3 + "]");
                            }
                            if (e instanceof HibernateException) {
                                throw (HibernateException)e;
                            }
                            if (e instanceof SQLException) {
                                throw JDBCExceptionHelper.convert(this.sqlExceptionConverter(), (SQLException)e, "error performing isolated work");
                            }
                            throw new HibernateException("error performing isolated work", e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        if (transacted && wasAutoCommit) {
                            try {
                                connection.setAutoCommit(true);
                            }
                            catch (Exception ignore2) {
                                log.trace("was unable to reset connection back to auto-commit");
                            }
                        }
                        try {
                            this.session.getFactory().getConnectionProvider().closeConnection(connection);
                        }
                        catch (Exception ignore2) {
                            log.info("Unable to release isolated connection [" + ignore2 + "]");
                        }
                        throw throwable;
                    }
                }
                catch (SQLException sqle) {
                    throw JDBCExceptionHelper.convert(this.sqlExceptionConverter(), sqle, "unable to obtain isolated JDBC connection");
                }
            }
        }

        private SQLExceptionConverter sqlExceptionConverter() {
            return this.session.getFactory().getSQLExceptionConverter();
        }
    }

    public static class JtaDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JtaDelegate(SessionImplementor session) {
            this.session = session;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void delegateWork(IsolatedWork work, boolean transacted) throws HibernateException {
            TransactionManager transactionManager = this.session.getFactory().getTransactionManager();
            try {
                Transaction surroundingTransaction = transactionManager.suspend();
                if (log.isDebugEnabled()) {
                    log.debug("surrounding JTA transaction suspended [" + surroundingTransaction + "]");
                }
                boolean hadProblems = false;
                try {
                    try {
                        if (transacted) {
                            this.doTheWorkInNewTransaction(work, transactionManager);
                        } else {
                            this.doTheWorkInNoTransaction(work);
                        }
                    }
                    catch (HibernateException e) {
                        hadProblems = true;
                        throw e;
                    }
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    try {
                        transactionManager.resume(surroundingTransaction);
                        if (!log.isDebugEnabled()) throw throwable;
                        log.debug("surrounding JTA transaction resumed [" + surroundingTransaction + "]");
                        throw throwable;
                    }
                    catch (Throwable t) {
                        if (hadProblems) throw throwable;
                        throw new HibernateException("Unable to resume previously suspended transaction", t);
                    }
                }
                try {}
                catch (Throwable t) {
                    if (hadProblems) return;
                    throw new HibernateException("Unable to resume previously suspended transaction", t);
                }
                transactionManager.resume(surroundingTransaction);
                if (!log.isDebugEnabled()) return;
                log.debug("surrounding JTA transaction resumed [" + surroundingTransaction + "]");
                return;
            }
            catch (SystemException e) {
                throw new HibernateException("Unable to suspend current JTA transaction", e);
            }
        }

        private void doTheWorkInNewTransaction(IsolatedWork work, TransactionManager transactionManager) {
            try {
                transactionManager.begin();
                try {
                    this.doTheWork(work);
                    transactionManager.commit();
                }
                catch (Exception e) {
                    try {
                        transactionManager.rollback();
                    }
                    catch (Exception ignore) {
                        log.info("Unable to rollback isolated transaction on error [" + e + "] : [" + ignore + "]");
                    }
                }
            }
            catch (SystemException e) {
                throw new HibernateException("Unable to start isolated transaction", e);
            }
            catch (NotSupportedException e) {
                throw new HibernateException("Unable to start isolated transaction", e);
            }
        }

        private void doTheWorkInNoTransaction(IsolatedWork work) {
            this.doTheWork(work);
        }

        /*
         * Loose catch block
         */
        private void doTheWork(IsolatedWork work) {
            block10: {
                try {
                    Connection connection = this.session.getFactory().getConnectionProvider().getConnection();
                    work.doWork(connection);
                    Object var5_4 = null;
                    try {
                        this.session.getFactory().getConnectionProvider().closeConnection(connection);
                    }
                    catch (Throwable ignore) {
                        log.info("Unable to release isolated connection [" + ignore + "]");
                    }
                    break block10;
                    {
                        catch (HibernateException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new HibernateException("Unable to perform isolated work", e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        try {
                            this.session.getFactory().getConnectionProvider().closeConnection(connection);
                        }
                        catch (Throwable ignore) {
                            log.info("Unable to release isolated connection [" + ignore + "]");
                        }
                        throw throwable;
                    }
                }
                catch (SQLException sqle) {
                    throw JDBCExceptionHelper.convert(this.sqlExceptionConverter(), sqle, "unable to obtain isolated JDBC connection");
                }
            }
        }

        private SQLExceptionConverter sqlExceptionConverter() {
            return this.session.getFactory().getSQLExceptionConverter();
        }
    }

    private static interface Delegate {
        public void delegateWork(IsolatedWork var1, boolean var2) throws HibernateException;
    }
}

