/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.tools.reflection;

import java.util.Map;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.tools.ConcurrentReferenceHashMap;
import org.hibernate.envers.tools.Pair;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionTools {
    private static final Map<Pair<Class, String>, Getter> getterCache = new ConcurrentReferenceHashMap<Pair<Class, String>, Getter>(10, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    private static final Map<Pair<Class, String>, Setter> setterCache = new ConcurrentReferenceHashMap<Pair<Class, String>, Setter>(10, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    public static Class<?> loadClass(String name) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new AuditException(e);
        }
    }

    private static PropertyAccessor getAccessor(String accessorType) {
        return PropertyAccessorFactory.getPropertyAccessor(accessorType);
    }

    public static Getter getGetter(Class cls, PropertyData propertyData) {
        return ReflectionTools.getGetter(cls, propertyData.getBeanName(), propertyData.getAccessType());
    }

    public static Getter getGetter(Class cls, String propertyName, String accessorType) {
        Pair<Class, String> key = Pair.make(cls, propertyName);
        Getter value = getterCache.get(key);
        if (value == null) {
            value = ReflectionTools.getAccessor(accessorType).getGetter(cls, propertyName);
            getterCache.put(key, value);
        }
        return value;
    }

    public static Setter getSetter(Class cls, PropertyData propertyData) {
        return ReflectionTools.getSetter(cls, propertyData.getBeanName(), propertyData.getAccessType());
    }

    private static Setter getSetter(Class cls, String propertyName, String accessorType) {
        Pair<Class, String> key = Pair.make(cls, propertyName);
        Setter value = setterCache.get(key);
        if (value == null) {
            value = ReflectionTools.getAccessor(accessorType).getSetter(cls, propertyName);
            setterCache.put(key, value);
        }
        return value;
    }
}

