/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class LockMode
implements Serializable {
    private final int level;
    private final String name;
    private static final Map INSTANCES = new HashMap();
    public static final LockMode NONE = new LockMode(0, "NONE");
    public static final LockMode READ = new LockMode(5, "READ");
    public static final LockMode UPGRADE = new LockMode(10, "UPGRADE");
    public static final LockMode UPGRADE_NOWAIT = new LockMode(10, "UPGRADE_NOWAIT");
    public static final LockMode WRITE = new LockMode(10, "WRITE");
    public static final LockMode FORCE = new LockMode(15, "FORCE");
    public static final LockMode OPTIMISTIC = new LockMode(3, "OPTIMISTIC");
    public static final LockMode OPTIMISTIC_FORCE_INCREMENT = new LockMode(4, "OPTIMISTIC_FORCE_INCREMENT");
    public static final LockMode PESSIMISTIC_READ = new LockMode(12, "PESSIMISTIC_READ");
    public static final LockMode PESSIMISTIC_WRITE = new LockMode(13, "PESSIMISTIC_WRITE");
    public static final LockMode PESSIMISTIC_FORCE_INCREMENT = new LockMode(17, "PESSIMISTIC_FORCE_INCREMENT");

    private LockMode(int level, String name) {
        this.level = level;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean greaterThan(LockMode mode) {
        return this.level > mode.level;
    }

    public boolean lessThan(LockMode mode) {
        return this.level < mode.level;
    }

    private Object readResolve() {
        return LockMode.parse(this.name);
    }

    public static LockMode parse(String name) {
        return (LockMode)INSTANCES.get(name);
    }

    static {
        INSTANCES.put(LockMode.NONE.name, NONE);
        INSTANCES.put(LockMode.READ.name, READ);
        INSTANCES.put(LockMode.UPGRADE.name, UPGRADE);
        INSTANCES.put(LockMode.UPGRADE_NOWAIT.name, UPGRADE_NOWAIT);
        INSTANCES.put(LockMode.WRITE.name, WRITE);
        INSTANCES.put(LockMode.FORCE.name, FORCE);
        INSTANCES.put(LockMode.OPTIMISTIC.name, OPTIMISTIC);
        INSTANCES.put(LockMode.OPTIMISTIC_FORCE_INCREMENT.name, OPTIMISTIC_FORCE_INCREMENT);
        INSTANCES.put(LockMode.PESSIMISTIC_READ.name, PESSIMISTIC_READ);
        INSTANCES.put(LockMode.PESSIMISTIC_WRITE.name, PESSIMISTIC_WRITE);
        INSTANCES.put(LockMode.PESSIMISTIC_FORCE_INCREMENT.name, PESSIMISTIC_FORCE_INCREMENT);
    }
}

