/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.jdbc.Work;
import org.hibernate.junit.FailureExpected;
import org.hibernate.junit.RequiresDialect;
import org.hibernate.junit.SkipForDialect;
import org.hibernate.junit.SkipLog;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateTestCase
extends TestCase {
    public static final Logger log = LoggerFactory.getLogger(HibernateTestCase.class);
    protected static Configuration cfg;
    private static Class<?> lastTestClass;
    private boolean runTest = true;
    private final Set<Class<? extends Dialect>> requiredDialectList = new HashSet<Class<? extends Dialect>>();
    private final Set<Class<? extends Dialect>> skipForDialectList = new HashSet<Class<? extends Dialect>>();

    public HibernateTestCase() {
    }

    public HibernateTestCase(String x) {
        super(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        Method runMethod = this.findTestMethod();
        Skip skip = this.determineSkipByDialect(Dialect.getDialect(), runMethod);
        if (skip != null) {
            this.reportSkip(skip);
            return;
        }
        this.setUp();
        try {
            this.runTest();
        }
        finally {
            this.tearDown();
        }
    }

    protected void runTest() throws Throwable {
        Method runMethod = this.findTestMethod();
        FailureExpected failureExpected = this.locateAnnotation(FailureExpected.class, runMethod);
        try {
            super.runTest();
            if (failureExpected != null) {
                throw new FailureExpectedTestPassedException();
            }
        }
        catch (FailureExpectedTestPassedException t) {
            this.closeResources();
            throw t;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t instanceof IllegalAccessException) {
                t.fillInStackTrace();
            }
            this.closeResources();
            if (failureExpected != null) {
                StringBuilder builder = new StringBuilder();
                if (StringHelper.isNotEmpty(failureExpected.message())) {
                    builder.append(failureExpected.message());
                } else {
                    builder.append("ignoring @FailureExpected test");
                }
                builder.append(" (").append(failureExpected.jiraKey()).append(")");
                SkipLog.LOG.warn(builder.toString(), t);
            }
            throw t;
        }
    }

    protected void setUp() throws Exception {
        if (cfg == null || lastTestClass != ((Object)((Object)this)).getClass()) {
            this.buildConfiguration();
            lastTestClass = ((Object)((Object)this)).getClass();
        } else {
            this.runSchemaGeneration();
        }
    }

    protected void tearDown() throws Exception {
        this.runSchemaDrop();
        this.handleUnclosedResources();
    }

    protected final Skip determineSkipByDialect(Dialect dialect, Method runMethod) {
        RequiresDialect requiresDialectAnn;
        SkipForDialect skipForDialectAnn = this.locateAnnotation(SkipForDialect.class, runMethod);
        if (skipForDialectAnn != null) {
            for (Class<? extends Dialect> dialectClass : skipForDialectAnn.value()) {
                if (!(skipForDialectAnn.strictMatching() ? dialectClass.equals(dialect.getClass()) : dialectClass.isInstance(dialect))) continue;
                return this.buildSkip(dialect, skipForDialectAnn.comment(), skipForDialectAnn.jiraKey());
            }
        }
        if ((requiresDialectAnn = this.locateAnnotation(RequiresDialect.class, runMethod)) != null) {
            for (Class<? extends Dialect> dialectClass : requiresDialectAnn.value()) {
                if (!(requiresDialectAnn.strictMatching() ? dialectClass.equals(dialect.getClass()) : dialectClass.isInstance(dialect))) continue;
                return this.buildSkip(dialect, null, null);
            }
        }
        return null;
    }

    protected <T extends Annotation> T locateAnnotation(Class<T> annotationClass, Method runMethod) {
        T annotation = runMethod.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = ((Object)((Object)this)).getClass().getAnnotation(annotationClass);
        }
        if (annotation == null) {
            annotation = runMethod.getDeclaringClass().getAnnotation(annotationClass);
        }
        return annotation;
    }

    protected Skip buildSkip(Dialect dialect, String comment, String jiraKey) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("skipping database-specific test [");
        buffer.append(this.fullTestName());
        buffer.append("] for dialect [");
        buffer.append(dialect.getClass().getName());
        buffer.append(']');
        if (StringHelper.isNotEmpty(comment)) {
            buffer.append("; ").append(comment);
        }
        if (StringHelper.isNotEmpty(jiraKey)) {
            buffer.append(" (").append(jiraKey).append(')');
        }
        return new Skip(buffer.toString(), null);
    }

    public String fullTestName() {
        return ((Object)((Object)this)).getClass().getName() + "#" + this.getName();
    }

    protected boolean runForCurrentDialect() {
        boolean runTestForCurrentDialect = true;
        for (Class<? extends Dialect> dialect : this.requiredDialectList) {
            if (dialect.isAssignableFrom(Dialect.getDialect().getClass())) {
                runTestForCurrentDialect = true;
                break;
            }
            runTestForCurrentDialect = false;
        }
        for (Class<? extends Dialect> dialect : this.skipForDialectList) {
            if (dialect.isAssignableFrom(Dialect.getDialect().getClass())) {
                runTestForCurrentDialect = false;
                break;
            }
            runTestForCurrentDialect = true;
        }
        return runTestForCurrentDialect;
    }

    private Method findTestMethod() {
        String fName = this.getName();
        HibernateTestCase.assertNotNull((Object)fName);
        Method runMethod = null;
        try {
            runMethod = ((Object)((Object)this)).getClass().getMethod(fName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            HibernateTestCase.fail((String)("Method \"" + fName + "\" not found"));
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            HibernateTestCase.fail((String)("Method \"" + fName + "\" should be public"));
        }
        return runMethod;
    }

    protected abstract void buildConfiguration() throws Exception;

    protected abstract Class<?>[] getAnnotatedClasses();

    protected String[] getMappings() {
        return new String[0];
    }

    protected abstract void handleUnclosedResources();

    protected abstract void closeResources();

    protected String[] getAnnotatedPackages() {
        return new String[0];
    }

    protected String[] getXmlFiles() {
        return new String[0];
    }

    protected Dialect getDialect() {
        return Dialect.getDialect();
    }

    protected static void setCfg(Configuration cfg) {
        HibernateTestCase.cfg = cfg;
    }

    protected static Configuration getCfg() {
        return cfg;
    }

    protected void configure(Configuration cfg) {
    }

    protected boolean recreateSchema() {
        return true;
    }

    protected void runSchemaGeneration() {
        SchemaExport export = new SchemaExport(cfg);
        export.create(true, true);
    }

    protected void runSchemaDrop() {
        SchemaExport export = new SchemaExport(cfg);
        export.drop(true, true);
    }

    private void reportSkip(Skip skip) {
        this.reportSkip(skip.reason, skip.testDescription);
    }

    protected void reportSkip(String reason, String testDescription) {
        StringBuilder builder = new StringBuilder();
        builder.append("*** skipping test [");
        builder.append(this.fullTestName());
        builder.append("] - ");
        builder.append(testDescription);
        builder.append(" : ");
        builder.append(reason);
        SkipLog.LOG.warn(builder.toString());
    }

    private static class FailureExpectedTestPassedException
    extends Exception {
        public FailureExpectedTestPassedException() {
            super("Test marked as @FailureExpected, but did not fail!");
        }
    }

    public class RollbackWork
    implements Work {
        public void execute(Connection connection) throws SQLException {
            connection.rollback();
        }
    }

    protected static class Skip {
        private final String reason;
        private final String testDescription;

        public Skip(String reason, String testDescription) {
            this.reason = reason;
            this.testDescription = testDescription;
        }
    }
}

