/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.QueryParameterException;
import org.hibernate.SQLQuery;
import org.hibernate.TypeMismatchException;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.ejb.AbstractQueryImpl;
import org.hibernate.ejb.HibernateQuery;
import org.hibernate.ejb.util.LockModeTypeHelper;
import org.hibernate.engine.query.NamedParameterDescriptor;
import org.hibernate.engine.query.OrdinalParameterDescriptor;
import org.hibernate.hql.QueryExecutionRequestException;
import org.hibernate.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl<X>
extends AbstractQueryImpl<X>
implements TypedQuery<X>,
HibernateQuery {
    private static final Logger log = LoggerFactory.getLogger(QueryImpl.class);
    private Query query;
    private Set<Integer> jpaPositionalIndices;
    private Set<Parameter<?>> parameters;
    private LockModeType jpaLockMode = LockModeType.NONE;

    public QueryImpl(Query query, AbstractEntityManagerImpl em) {
        this(query, em, Collections.emptyMap());
    }

    public QueryImpl(Query query, AbstractEntityManagerImpl em, Map<String, Class> namedParameterTypeRedefinitions) {
        super(em);
        this.query = query;
        this.extractParameterInfo(namedParameterTypeRedefinitions);
    }

    private void extractParameterInfo(Map<String, Class> namedParameterTypeRedefinition) {
        Serializable descriptor;
        if (!org.hibernate.impl.AbstractQueryImpl.class.isInstance(this.query)) {
            throw new IllegalStateException("Unknown query type for parameter extraction");
        }
        HashSet<ParameterImpl> parameters = new HashSet<ParameterImpl>();
        org.hibernate.impl.AbstractQueryImpl queryImpl = (org.hibernate.impl.AbstractQueryImpl)org.hibernate.impl.AbstractQueryImpl.class.cast(this.query);
        for (String name : queryImpl.getParameterMetadata().getNamedParameterNames()) {
            descriptor = queryImpl.getParameterMetadata().getNamedParameterDescriptor(name);
            Class javaType = namedParameterTypeRedefinition.get(name);
            if (javaType != null && this.mightNeedRedefinition(javaType)) {
                ((NamedParameterDescriptor)descriptor).resetExpectedType(TypeFactory.heuristicType(javaType.getName()));
            } else if (((NamedParameterDescriptor)descriptor).getExpectedType() != null) {
                javaType = ((NamedParameterDescriptor)descriptor).getExpectedType().getReturnedClass();
            }
            ParameterImpl parameter = new ParameterImpl(name, javaType);
            parameters.add(parameter);
            if (!((NamedParameterDescriptor)descriptor).isJpaStyle()) continue;
            if (this.jpaPositionalIndices == null) {
                this.jpaPositionalIndices = new HashSet<Integer>();
            }
            this.jpaPositionalIndices.add(Integer.valueOf(name));
        }
        int max = queryImpl.getParameterMetadata().getOrdinalParameterCount();
        for (int i = 0; i < max; ++i) {
            descriptor = queryImpl.getParameterMetadata().getOrdinalParameterDescriptor(i + 1);
            ParameterImpl parameter = new ParameterImpl(i + 1, ((OrdinalParameterDescriptor)descriptor).getExpectedType() == null ? null : ((OrdinalParameterDescriptor)descriptor).getExpectedType().getReturnedClass());
            parameters.add(parameter);
            Integer position = ((OrdinalParameterDescriptor)descriptor).getOrdinalPosition();
            if (this.jpaPositionalIndices == null || !this.jpaPositionalIndices.contains(position)) continue;
            log.warn("Parameter position [" + position + "] occurred as both JPA and Hibernate positional parameter");
        }
        this.parameters = Collections.unmodifiableSet(parameters);
    }

    private boolean mightNeedRedefinition(Class javaType) {
        return Date.class.isAssignableFrom(javaType);
    }

    @Override
    public Query getHibernateQuery() {
        return this.query;
    }

    @Override
    protected int internalExecuteUpdate() {
        return this.query.executeUpdate();
    }

    @Override
    protected void applyMaxResults(int maxResults) {
        this.query.setMaxResults(maxResults);
    }

    @Override
    protected void applyFirstResult(int firstResult) {
        this.query.setFirstResult(firstResult);
    }

    @Override
    protected void applyTimeout(int timeout) {
        this.query.setTimeout(timeout);
    }

    @Override
    protected void applyComment(String comment) {
        this.query.setComment(comment);
    }

    @Override
    protected void applyFetchSize(int fetchSize) {
        this.query.setFetchSize(fetchSize);
    }

    @Override
    protected void applyCacheable(boolean isCacheable) {
        this.query.setCacheable(isCacheable);
    }

    @Override
    protected void applyCacheRegion(String regionName) {
        this.query.setCacheRegion(regionName);
    }

    @Override
    protected void applyReadOnly(boolean isReadOnly) {
        this.query.setReadOnly(isReadOnly);
    }

    @Override
    protected void applyCacheMode(CacheMode cacheMode) {
        this.query.setCacheMode(cacheMode);
    }

    @Override
    protected void applyFlushMode(FlushMode flushMode) {
        this.query.setFlushMode(flushMode);
    }

    @Override
    protected boolean canApplyLockModes() {
        return org.hibernate.impl.QueryImpl.class.isInstance(this.query);
    }

    @Override
    protected void applyAliasSpecificLockMode(String alias, LockMode lockMode) {
        ((org.hibernate.impl.QueryImpl)this.query).getLockOptions().setAliasSpecificLockMode(alias, lockMode);
    }

    public List<X> getResultList() {
        try {
            return this.query.list();
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getEntityManager().convert(he);
        }
    }

    public X getSingleResult() {
        try {
            boolean mucked = false;
            if (this.getSpecifiedMaxResults() != 1 && !SQLQuery.class.isAssignableFrom(this.query.getClass())) {
                mucked = true;
                this.query.setMaxResults(2);
            }
            List result = this.query.list();
            if (mucked) {
                this.query.setMaxResults(this.getSpecifiedMaxResults());
            }
            if (result.size() == 0) {
                NoResultException nre = new NoResultException("No entity found for query");
                this.getEntityManager().handlePersistenceException((PersistenceException)nre);
                throw nre;
            }
            if (result.size() > 1) {
                HashSet uniqueResult = new HashSet(result);
                if (uniqueResult.size() > 1) {
                    NonUniqueResultException nure = new NonUniqueResultException("result returns more than one elements");
                    this.getEntityManager().handlePersistenceException((PersistenceException)nure);
                    throw nure;
                }
                return (X)uniqueResult.iterator().next();
            }
            return (X)result.get(0);
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getEntityManager().convert(he);
        }
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T value) {
        if (!this.parameters.contains(param)) {
            throw new IllegalArgumentException("Specified parameter was not found in query");
        }
        if (param.getName() != null) {
            this.setParameter(param.getName(), value);
        } else {
            this.setParameter(param.getPosition(), value);
        }
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        if (!this.parameters.contains(param)) {
            throw new IllegalArgumentException("Specified parameter was not found in query");
        }
        if (param.getName() != null) {
            this.setParameter(param.getName(), value, temporalType);
        } else {
            this.setParameter((int)param.getPosition(), value, temporalType);
        }
        return this;
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        if (!this.parameters.contains(param)) {
            throw new IllegalArgumentException("Specified parameter was not found in query");
        }
        if (param.getName() != null) {
            this.setParameter(param.getName(), value, temporalType);
        } else {
            this.setParameter((int)param.getPosition(), value, temporalType);
        }
        return this;
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        try {
            if (value instanceof Collection) {
                this.query.setParameterList(name, (Collection)value);
            } else {
                this.query.setParameter(name, value);
            }
            this.registerParameterBinding(this.getParameter(name), value);
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getEntityManager().convert(he);
        }
    }

    public TypedQuery<X> setParameter(String name, Date value, TemporalType temporalType) {
        try {
            if (temporalType == TemporalType.DATE) {
                this.query.setDate(name, value);
            } else if (temporalType == TemporalType.TIME) {
                this.query.setTime(name, value);
            } else if (temporalType == TemporalType.TIMESTAMP) {
                this.query.setTimestamp(name, value);
            }
            this.registerParameterBinding(this.getParameter(name), value);
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getEntityManager().convert(he);
        }
    }

    public TypedQuery<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        try {
            if (temporalType == TemporalType.DATE) {
                this.query.setCalendarDate(name, value);
            } else {
                if (temporalType == TemporalType.TIME) {
                    throw new IllegalArgumentException("not yet implemented");
                }
                if (temporalType == TemporalType.TIMESTAMP) {
                    this.query.setCalendar(name, value);
                }
            }
            this.registerParameterBinding(this.getParameter(name), value);
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getEntityManager().convert(he);
        }
    }

    public TypedQuery<X> setParameter(int position, Object value) {
        try {
            if (this.isJpaPositionalParameter(position)) {
                this.setParameter(Integer.toString(position), value);
            } else {
                this.query.setParameter(position - 1, value);
                this.registerParameterBinding(this.getParameter(position), value);
            }
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getEntityManager().convert(he);
        }
    }

    private boolean isJpaPositionalParameter(int position) {
        return this.jpaPositionalIndices != null && this.jpaPositionalIndices.contains(position);
    }

    public TypedQuery<X> setParameter(int position, Date value, TemporalType temporalType) {
        try {
            if (this.isJpaPositionalParameter(position)) {
                String name = Integer.toString(position);
                this.setParameter(name, value, temporalType);
            } else {
                if (temporalType == TemporalType.DATE) {
                    this.query.setDate(position - 1, value);
                } else if (temporalType == TemporalType.TIME) {
                    this.query.setTime(position - 1, value);
                } else if (temporalType == TemporalType.TIMESTAMP) {
                    this.query.setTimestamp(position - 1, value);
                }
                this.registerParameterBinding(this.getParameter(position), value);
            }
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getEntityManager().convert(he);
        }
    }

    public TypedQuery<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        try {
            if (this.isJpaPositionalParameter(position)) {
                String name = Integer.toString(position);
                this.setParameter(name, value, temporalType);
            } else {
                if (temporalType == TemporalType.DATE) {
                    this.query.setCalendarDate(position - 1, value);
                } else {
                    if (temporalType == TemporalType.TIME) {
                        throw new IllegalArgumentException("not yet implemented");
                    }
                    if (temporalType == TemporalType.TIMESTAMP) {
                        this.query.setCalendar(position - 1, value);
                    }
                }
                this.registerParameterBinding(this.getParameter(position), value);
            }
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getEntityManager().convert(he);
        }
    }

    public Set<Parameter<?>> getParameters() {
        return this.parameters;
    }

    public Parameter<?> getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name of parameter to locate cannot be null");
        }
        for (Parameter<?> parameter : this.parameters) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        throw new IllegalArgumentException("Unable to locate parameter named [" + name + "]");
    }

    public Parameter<?> getParameter(int position) {
        if (this.isJpaPositionalParameter(position)) {
            return this.getParameter(Integer.toString(position));
        }
        for (Parameter<?> parameter : this.parameters) {
            if (parameter.getPosition() == null || position != parameter.getPosition()) continue;
            return parameter;
        }
        throw new IllegalArgumentException("Unable to locate parameter with position [" + position + "]");
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        Parameter<?> param = this.getParameter(name);
        if (param.getParameterType() != null) {
            throw new IllegalArgumentException("Parameter type [" + param.getParameterType().getName() + "] is not assignment compatible with requested type [" + type.getName() + "]");
        }
        return param;
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        Parameter<?> param = this.getParameter(position);
        if (param.getParameterType() != null) {
            throw new IllegalArgumentException("Parameter type [" + param.getParameterType().getName() + "] is not assignment compatible with requested type [" + type.getName() + "]");
        }
        return param;
    }

    public <T> T unwrap(Class<T> tClass) {
        if (Query.class.isAssignableFrom(tClass)) {
            return (T)this.query;
        }
        try {
            return (T)this;
        }
        catch (ClassCastException cce) {
            PersistenceException pe = new PersistenceException("Unsupported unwrap target type [" + tClass.getName() + "]");
            throw pe;
        }
    }

    @Override
    public TypedQuery<X> setLockMode(LockModeType lockModeType) {
        if (!this.getEntityManager().isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress");
        }
        if (!this.canApplyLockModes()) {
            throw new IllegalStateException("Not a JPAQL/Criteria query");
        }
        this.jpaLockMode = lockModeType;
        ((org.hibernate.impl.QueryImpl)this.query).getLockOptions().setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        return this;
    }

    @Override
    public LockModeType getLockMode() {
        return this.jpaLockMode;
    }

    private static class ParameterImpl
    implements Parameter {
        private final String name;
        private final Integer position;
        private final Class javaType;

        private ParameterImpl(String name, Class javaType) {
            this.name = name;
            this.javaType = javaType;
            this.position = null;
        }

        private ParameterImpl(Integer position, Class javaType) {
            this.position = position;
            this.javaType = javaType;
            this.name = null;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPosition() {
            return this.position;
        }

        public Class getParameterType() {
            return this.javaType;
        }
    }
}

