/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;

public final class EntityEntry
implements Serializable {
    private LockMode lockMode;
    private Status status;
    private Status previousStatus;
    private final Serializable id;
    private Object[] loadedState;
    private Object[] deletedState;
    private boolean existsInDatabase;
    private Object version;
    private transient EntityPersister persister;
    private final EntityMode entityMode;
    private final String entityName;
    private transient EntityKey cachedEntityKey;
    private boolean isBeingReplicated;
    private boolean loadedWithLazyPropertiesUnfetched;
    private final transient Object rowId;

    EntityEntry(Status status, Object[] loadedState, Object rowId, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, EntityMode entityMode, boolean disableVersionIncrement, boolean lazyPropertiesAreUnfetched) {
        this.status = status;
        this.previousStatus = null;
        if (status != Status.READ_ONLY) {
            this.loadedState = loadedState;
        }
        this.id = id;
        this.rowId = rowId;
        this.existsInDatabase = existsInDatabase;
        this.version = version;
        this.lockMode = lockMode;
        this.isBeingReplicated = disableVersionIncrement;
        this.loadedWithLazyPropertiesUnfetched = lazyPropertiesAreUnfetched;
        this.persister = persister;
        this.entityMode = entityMode;
        this.entityName = persister == null ? null : persister.getEntityName();
    }

    private EntityEntry(SessionFactoryImplementor factory, String entityName, Serializable id, EntityMode entityMode, Status status, Status previousStatus, Object[] loadedState, Object[] deletedState, Object version, LockMode lockMode, boolean existsInDatabase, boolean isBeingReplicated, boolean loadedWithLazyPropertiesUnfetched) {
        this.entityName = entityName;
        this.persister = factory == null ? null : factory.getEntityPersister(entityName);
        this.id = id;
        this.entityMode = entityMode;
        this.status = status;
        this.previousStatus = previousStatus;
        this.loadedState = loadedState;
        this.deletedState = deletedState;
        this.version = version;
        this.lockMode = lockMode;
        this.existsInDatabase = existsInDatabase;
        this.isBeingReplicated = isBeingReplicated;
        this.loadedWithLazyPropertiesUnfetched = loadedWithLazyPropertiesUnfetched;
        this.rowId = null;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        if (status == Status.READ_ONLY) {
            this.loadedState = null;
        }
        if (this.status != status) {
            this.previousStatus = this.status;
            this.status = status;
        }
    }

    public Serializable getId() {
        return this.id;
    }

    public Object[] getLoadedState() {
        return this.loadedState;
    }

    public Object[] getDeletedState() {
        return this.deletedState;
    }

    public void setDeletedState(Object[] deletedState) {
        this.deletedState = deletedState;
    }

    public boolean isExistsInDatabase() {
        return this.existsInDatabase;
    }

    public Object getVersion() {
        return this.version;
    }

    public EntityPersister getPersister() {
        return this.persister;
    }

    public EntityKey getEntityKey() {
        if (this.cachedEntityKey == null) {
            if (this.getId() == null) {
                throw new IllegalStateException("cannot generate an EntityKey when id is null.");
            }
            this.cachedEntityKey = new EntityKey(this.getId(), this.getPersister(), this.entityMode);
        }
        return this.cachedEntityKey;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean isBeingReplicated() {
        return this.isBeingReplicated;
    }

    public Object getRowId() {
        return this.rowId;
    }

    public void postUpdate(Object entity, Object[] updatedState, Object nextVersion) {
        this.loadedState = updatedState;
        this.setLockMode(LockMode.WRITE);
        if (this.getPersister().isVersioned()) {
            this.version = nextVersion;
            this.getPersister().setPropertyValue(entity, this.getPersister().getVersionProperty(), nextVersion, this.entityMode);
        }
        FieldInterceptionHelper.clearDirty(entity);
    }

    public void postDelete() {
        this.previousStatus = this.status;
        this.status = Status.GONE;
        this.existsInDatabase = false;
    }

    public void postInsert() {
        this.existsInDatabase = true;
    }

    public boolean isNullifiable(boolean earlyInsert, SessionImplementor session) {
        return this.getStatus() == Status.SAVING || (earlyInsert ? !this.isExistsInDatabase() : session.getPersistenceContext().getNullifiableEntityKeys().contains(this.getEntityKey()));
    }

    public Object getLoadedValue(String propertyName) {
        int propertyIndex = ((UniqueKeyLoadable)this.persister).getPropertyIndex(propertyName);
        return this.loadedState[propertyIndex];
    }

    public boolean requiresDirtyCheck(Object entity) {
        return this.isModifiableEntity() && (this.getPersister().hasMutableProperties() || !FieldInterceptionHelper.isInstrumented(entity) || FieldInterceptionHelper.extractFieldInterceptor(entity).isDirty());
    }

    public boolean isModifiableEntity() {
        return this.status != Status.READ_ONLY && (this.status != Status.DELETED || this.previousStatus != Status.READ_ONLY) && this.getPersister().isMutable();
    }

    public void forceLocked(Object entity, Object nextVersion) {
        this.loadedState[this.persister.getVersionProperty()] = this.version = nextVersion;
        this.setLockMode(LockMode.FORCE);
        this.persister.setPropertyValue(entity, this.getPersister().getVersionProperty(), nextVersion, this.entityMode);
    }

    public boolean isReadOnly() {
        if (this.status != Status.MANAGED && this.status != Status.READ_ONLY) {
            throw new HibernateException("instance was not in a valid state");
        }
        return this.status == Status.READ_ONLY;
    }

    public void setReadOnly(boolean readOnly, Object entity) {
        if (readOnly == this.isReadOnly()) {
            return;
        }
        if (readOnly) {
            this.setStatus(Status.READ_ONLY);
            this.loadedState = null;
        } else {
            if (!this.persister.isMutable()) {
                throw new IllegalStateException("Cannot make an immutable entity modifiable.");
            }
            this.setStatus(Status.MANAGED);
            this.loadedState = this.getPersister().getPropertyValues(entity, this.entityMode);
        }
    }

    public String toString() {
        return "EntityEntry" + MessageHelper.infoString(this.entityName, this.id) + '(' + this.status + ')';
    }

    public boolean isLoadedWithLazyPropertiesUnfetched() {
        return this.loadedWithLazyPropertiesUnfetched;
    }

    void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.entityName);
        oos.writeObject(this.id);
        oos.writeObject(this.entityMode.toString());
        oos.writeObject(this.status.toString());
        oos.writeObject(this.previousStatus == null ? "" : this.previousStatus.toString());
        oos.writeObject(this.loadedState);
        oos.writeObject(this.deletedState);
        oos.writeObject(this.version);
        oos.writeObject(this.lockMode.toString());
        oos.writeBoolean(this.existsInDatabase);
        oos.writeBoolean(this.isBeingReplicated);
        oos.writeBoolean(this.loadedWithLazyPropertiesUnfetched);
    }

    static EntityEntry deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        String previousStatusString = null;
        previousStatusString = (String)ois.readObject();
        return new EntityEntry(session == null ? null : session.getFactory(), (String)ois.readObject(), (Serializable)ois.readObject(), EntityMode.parse((String)ois.readObject()), Status.parse((String)ois.readObject()), previousStatusString.length() == 0 ? null : Status.parse(previousStatusString), (Object[])ois.readObject(), (Object[])ois.readObject(), ois.readObject(), LockMode.parse((String)ois.readObject()), ois.readBoolean(), ois.readBoolean(), ois.readBoolean());
    }
}

