/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.Hibernate;
import org.hibernate.PersistentObjectException;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.def.DefaultSaveOrUpdateEventListener;

public class DefaultSaveEventListener
extends DefaultSaveOrUpdateEventListener {
    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent event) {
        EntityEntry entry = event.getSession().getPersistenceContext().getEntry(event.getEntity());
        if (entry != null && entry.getStatus() != Status.DELETED) {
            return this.entityIsPersistent(event);
        }
        return this.entityIsTransient(event);
    }

    protected Serializable saveWithGeneratedOrRequestedId(SaveOrUpdateEvent event) {
        if (event.getRequestedId() == null) {
            return super.saveWithGeneratedOrRequestedId(event);
        }
        return this.saveWithRequestedId(event.getEntity(), event.getRequestedId(), event.getEntityName(), null, event.getSession());
    }

    protected boolean reassociateIfUninitializedProxy(Object object, SessionImplementor source) {
        if (!Hibernate.isInitialized(object)) {
            throw new PersistentObjectException("uninitialized proxy passed to save()");
        }
        return false;
    }
}

