package org.gcube.common.homelibrary.client.servlet;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.gcube.common.homelibrary.client.util.Config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;

public class Servlets {

	/**
	 * Get jackrabbit credentials
	 * @return a string with credentials
	 */
	public static String getCredentials() {
		String credentials = "adminId=" + Config.USERNAME + "&adminPassword=" + Config.PASSWORD;
		return credentials;
	}


	/**
	 * Delete files or folder
	 * @param absPath absolute path of the item to delete
	 * @return true if the file/folder has been deleted
	 * @throws Exception
	 */
	public static Boolean delete(String absPath) throws Exception{
		XStream xstream = null;
		String xmlOut = null;
		Boolean flag = false;
		try{
			String uri = Config.URL_REPOSITORY + "/post/Delete";
			String urlParameters = getCredentials() + "&portalLogin=" + Config.LOGIN + "&scope=" + Config.SCOPE + "&serviceName=" + Config.SERVICE_NAME+ "&absPath=" +  URLEncoder.encode(absPath, "UTF-8") ;
			URL url = new URL(uri);
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setRequestMethod("POST");
			connection.setRequestProperty("Accept", "application/xml");

			// Send post request
			connection.setDoOutput(true);
			DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
			wr.writeBytes(urlParameters);
			wr.flush();
			wr.close();

			int responseCode = connection.getResponseCode();
			//			System.out.println("\nSending 'POST' request to URL : " + url);
			//			System.out.println("Post parameters : " + urlParameters);
			System.out.println("Response Code : " + responseCode);

			xstream = new XStream();

			BufferedReader in = new BufferedReader(
					new InputStreamReader(connection.getInputStream()));

			StringBuffer response = new StringBuffer();
			String inputLine;
			while ((inputLine = in.readLine()) != null) {
				response.append(inputLine);
			}
			in.close();

			xmlOut = response.toString();

			connection.disconnect();

		
			flag = (Boolean) xstream.fromXML(xmlOut);


		} catch (ClassCastException e) {
			
			System.out.println((String) xstream.fromXML(xmlOut));
			//			System.out.println(absPath + " not deleted.");
			//			throw new Exception(e.getMessage());
		} 

		return flag;

	}



	/**
	 * Save a file
	 * @param path
	 * @param name
	 * @param description
	 * @param parentPath
	 * @return
	 * @throws Exception
	 */
	public static String save(String path, String name, String description, String parentPath) throws Exception {

		//		System.out.println("Save file " + name +  " in " + parentPath);

		String item = null;

		PostMethod post = null;
		HttpClient httpClient = new HttpClient(); 
		XStream xstream = new XStream(new DomDriver("UTF-8"));
		try {

			File file = new File(path);

			if (name==null)
				name = file.getName();

			//			System.out.println(Config.URL_REPOSITORY + "/post/Save?" + getCredentials() + "&uuid=" + sessionId + "&portalLogin=" + Config.LOGIN + "&scope=" + Config.SCOPE + "&filename=" + file.getName()+ "&serviceName=" + Config.SERVICE_NAME+ "&name=" + name+ "&description=" + URLEncoder.encode(description, "UTF-8") + "&parentPath=" + URLEncoder.encode(parentPath, "UTF-8"));
			post =  new PostMethod(Config.URL_REPOSITORY + "/post/Save?" + getCredentials() + "&portalLogin=" + Config.LOGIN + "&scope=" + Config.SCOPE + "&filename=" + file.getName()+ "&serviceName=" + Config.SERVICE_NAME+ "&name=" + name+ "&description=" + URLEncoder.encode(description, "UTF-8") + "&parentPath=" + URLEncoder.encode(parentPath, "UTF-8"));
			//			post.setRequestEntity(new StringRequestEntity(xstream.toXML(item), "application/octet-stream", null));

			post.setRequestEntity(new FileRequestEntity(file, "image/jpeg"));

			// execute the POST
			int response = httpClient.executeMethod(post);
			// Check response code
			if (response != HttpStatus.SC_OK)
				throw new HttpException("Received error status " + response);

			item = (String) xstream.fromXML(post.getResponseBodyAsStream());

		} catch (IOException e) {
			throw new Exception(e.getMessage());
		} finally {
			if(post != null)
				post.releaseConnection();
		}

		return item;
	}


	/**
	 * Create a folder
	 * @param name
	 * @param description
	 * @param parentPath
	 * @return
	 * @throws Exception
	 */
	public static String createFolder(String name, String description,
			String parentPath) throws Exception {

		System.out.println("Create Folder " + name);
		String uri = Config.URL_REPOSITORY + "/post/CreateFolder";
		String urlParameters = getCredentials() + "&portalLogin=" + Config.LOGIN + "&name=" + name+ "&description=" + URLEncoder.encode(description, "UTF-8") + "&parentPath=" + URLEncoder.encode(parentPath, "UTF-8");
		URL url = new URL(uri);
		HttpURLConnection connection = (HttpURLConnection) url.openConnection();
		connection.setRequestMethod("POST");
		connection.setRequestProperty("Accept", "application/xml");

		// Send post request
		connection.setDoOutput(true);
		DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
		wr.writeBytes(urlParameters);
		wr.flush();
		wr.close();

		int responseCode = connection.getResponseCode();
		//		System.out.println("\nSending 'POST' request to URL : " + url);
		//		System.out.println("Post parameters : " + urlParameters);
		System.out.println("Response Code : " + responseCode);

		XStream xstream = new XStream();

		BufferedReader in = new BufferedReader(
				new InputStreamReader(connection.getInputStream()));

		StringBuffer response = new StringBuffer();
		String inputLine;
		while ((inputLine = in.readLine()) != null) {
			response.append(inputLine);
		}
		in.close();

		String xmlOut = response.toString();

		connection.disconnect();
		return (String) xstream.fromXML(xmlOut);

	}

	/**
	 * List content of a folder
	 * @param absPath
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static List<String> listFolder(String absPath) throws Exception {
		
		XStream xstream = new XStream();
		String xmlOut = null;
		List<String> list = null;
		try{
			String uri = Config.URL_REPOSITORY + "/get/ListFolder?" + getCredentials() + "&portalLogin=" + Config.LOGIN + "&absPath=" + URLEncoder.encode(absPath, "UTF-8");

			URL url = new URL(uri);
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.setRequestMethod("GET");
			connection.setRequestProperty("Accept", "application/xml");

			int responseCode = connection.getResponseCode();
			//		System.out.println("\nSending 'GET' request to URL : " + uri);
			System.out.println("Response Code : " + responseCode);

			

			BufferedReader in = new BufferedReader(
					new InputStreamReader(connection.getInputStream()));

			StringBuffer response = new StringBuffer();
			String inputLine;
			while ((inputLine = in.readLine()) != null) {
				response.append(inputLine);
			}
			in.close();

			xmlOut = response.toString();

			connection.disconnect();

			list = (List<String>) xstream.fromXML(xmlOut);
			
		} catch (ClassCastException e) {
			
			System.out.println((String) xstream.fromXML(xmlOut));
			//		System.out.println(absPath + " not deleted.");
			//		throw new Exception(e.getMessage());
		} 

		return list;

	}



}
