/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.search;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.search.SearchFolder;

public class JCRSearchFolder
implements SearchFolder {
    private final String id;
    private final Calendar creationDate;
    private final Calendar lastModified;
    private final String owner;
    private final String type;
    protected String name;

    public JCRSearchFolder(Node node, String name) throws RepositoryException {
        this.id = node.getIdentifier();
        this.name = name;
        this.creationDate = node.getProperty("jcr:created").getDate();
        this.lastModified = node.getProperty("jcr:lastModified").getDate();
        Node nodeOwner = null;
        try {
            nodeOwner = node.getNode("hl:owner");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.owner = nodeOwner.getProperty("hl:portalLogin").getString();
        this.type = node.getPrimaryNodeType().getName();
        System.out.println("type " + this.type);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public String getOwner() {
        return this.owner;
    }

    public WorkspaceItemType getType() {
        if (this.type.equals("nthl:workspaceSharedItem")) {
            return WorkspaceItemType.SHARED_FOLDER;
        }
        return WorkspaceItemType.FOLDER;
    }
}

