package org.gcube.common.homelibrary.jcr.repository.external;

import java.io.IOException;
import java.io.InputStream;

import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCUBEStorage {

	private static Logger logger = LoggerFactory.getLogger(GCUBEStorage.class);
	private static IClient storage;
	private static String scope;

	static {
		try {

			String currentScope = ScopeProvider.instance.get();
			scope = Utils.getRootScope(currentScope);

			
			ScopeProvider.instance.set(scope);
			logger.info("GCUBE Storage current scope : " + currentScope);
//			storage = new StorageClient("org.gcube.portlets.user","home-library",
//					"home-library",AccessType.SHARED, currentScope, false).getClient();
			
			
			storage = new StorageClient("org.gcube.portlets.user","home-library",
					"home-library",AccessType.SHARED, currentScope, false).getClient();

			Handler.activateProtocol();

		} catch (Exception e) {
			logger.error("GCUBE Storage initialization failed",e);
		}
	}

	public static String putStream(InputStream is, String remotePath) throws RemoteBackendException {

		ScopeProvider.instance.set(scope);
		logger.info("GCUBE Storage scope : " + scope);
//		System.out.println("GCUBE Storage RFile path : " + remotePath);
		storage.put(true).LFile(is).RFile(remotePath);
		try {
			is.close();
			logger.trace("GCUBE Storage inputStream closed");
		} catch (IOException e) {
			logger.error("GCUBE Storage error during to close inputStream",e);
		}

		return storage.getUrl().RFile(remotePath);
	}

	public static long getRemoteFileSize(String remotePath) throws RemoteBackendException {

		ScopeProvider.instance.set(scope);
		logger.info("GCUBE Storage RFile path : " + remotePath);
		long size = storage.getSize().RFile(remotePath);
		return size;
	}

	//delete file	
	public static void removeRemoteFile(String remotePath) throws RemoteBackendException {

		ScopeProvider.instance.set(scope);
		logger.info("GCUBE Storage RFile path : " + remotePath);
		storage.remove().RFile(remotePath);
	}

	//delete folder
	public static void removeRemoteFolder(String remotePath) throws RemoteBackendException {

		ScopeProvider.instance.set(scope);
		logger.info("GCUBE Storage RDir path : " + remotePath);
		storage.removeDir().RDir(remotePath);
	}
	
	public static InputStream getRemoteFile(String remotePath) {
		ScopeProvider.instance.set(scope);
		InputStream stream = null;
		try{
			stream = storage.get().RFileAsInputStream(remotePath);
		}catch (Exception e) {
			logger.error("no payload found in Storage for remotePath: " + remotePath );
		}
		return stream;
	}


	public static String getPublicLink(String remotePath) {
		String publicUrl = storage.getUrl().RFile(remotePath);
		logger.info("Generate Public Link for " + remotePath);
		return publicUrl;
	}
	
	//move dir
	public static void moveRemoteFolder(String oldPath, String newPath) {
		storage.moveDir().from(oldPath).to(newPath);
	}
	
	//move file
	public static void moveRemoteFile(String oldPath, String newPath) {
		
//		System.out.println("storage.moveFile().from(" + oldPath + ").to(" +newPath +")");
		//		storage.moveFile().from("/Home/valentina.marioli/Workspace/doors.jpg").to("/Home/valentina.marioli/Workspace/test/doors.jpg");
		storage.moveFile().from(oldPath).to(newPath);
	}
	
	

	//use remotepath to access storage
	public static void createHardLink(String srcPath, String destPath) {
		try{
			storage.linkFile().from(srcPath).to(destPath);
			logger.info("GCUBE Storage linkFile path : " + destPath);
//			System.out.println("created a hard link");
		}catch (Exception e) {
			logger.error("GCUBE Storage error creating a linkFile",e);
		}
	}

	//	public static InputStream getInputStream(URL url) throws IOException {
	//		
	//		URLConnection uc = url.openConnection();
	//		InputStream is=uc.getInputStream();
	//		return is;
	//	}

}
