package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;

import com.thoughtworks.xstream.XStream;

public class JCRGCubeItem extends JCRWorkspaceItem implements GCubeItem {


	private static final String SCOPES 			= "hl:scopes";
	private static final String CREATOR 		= "hl:creator";
	private static final String ITEM_TYPE 		= "hl:itemType"; 
	private static final String PROPERTIES 		= "hl:properties";

	private List<String> scopes;
	private String itemType;
	private String creator;
	private Map<String,String> properties = null;
	private JCRWorkspaceItem parent;

	public JCRGCubeItem(JCRWorkspace workspace, Node node, String name,
			String description, List<String> scopes, String creator, String itemType, Map<String, String> properties) throws RepositoryException, ItemNotFoundException {
		super(workspace, node, name, description);

		Validate.notNull(scopes, "scopes must be not null");
		Validate.notNull(creator, "creator must be not null");
		Validate.notNull(itemType, "item type must be not null");


		this.parent = (JCRWorkspaceItem) workspace.getItem(node.getParent().getIdentifier());
		this.scopes =  scopes;
		this.creator = creator;
		this.itemType = itemType;
		this.properties = properties;		

		node.setProperty(CREATOR, creator);
		node.setProperty(ITEM_TYPE, itemType);
		node.setProperty(SCOPES, scopes.toArray(new String[0]));


		if (properties!=null){
			node.setProperty(PROPERTIES, new XStream().toXML(properties));
		}
	}

	@SuppressWarnings("unchecked")
	public JCRGCubeItem(JCRWorkspace workspace, Node node)
			throws RepositoryException {
		super(workspace, node);
		this.scopes =new ArrayList<String>();
		for (Value value : node.getProperty(SCOPES).getValues())
			scopes.add(value.getString());
		creator = node.getProperty(CREATOR).getString();
		itemType = node.getProperty(ITEM_TYPE).getString();
		if (node.hasProperty(PROPERTIES) && node.getProperty(PROPERTIES)!=null) 
			properties =(Map<String, String>) new XStream().fromXML(node.getProperty(PROPERTIES).getString());
		else properties = Collections.emptyMap();
	}

	@Override
	public WorkspaceItemType getType() {
		return WorkspaceItemType.FOLDER_ITEM;
	}

	@Override
	public List<? extends WorkspaceItem> getChildren()
			throws InternalErrorException {
		return null;
	}

	@Override
	public List<String> getScopes() {
		return scopes;
	}

	@Override
	public String getItemType() {
		return itemType;
	}

	@Override
	public String getCreator() {
		return creator;
	}

	@Override
	public Map<String, String> getItemProperties() {
		return properties;
	}


	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.GCUBE_ITEM;
	}

	@Override
	public long getLength() throws InternalErrorException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public String getMimeType() throws InternalErrorException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem#move(org.gcube.common.homelibrary.home.workspace.WorkspaceFolder)
	 */
	@Override
	public void move(WorkspaceFolder destination)
			throws InternalErrorException, WrongDestinationException,
			InsufficientPrivilegesException, ItemAlreadyExistException {
		throw new InsufficientPrivilegesException("GCUBEItem cannot be moved");
	}

	/* (non-Javadoc)
	 * @see org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem#internalCopy(javax.jcr.Node, java.lang.String)
	 */
	@Override
	public Node internalCopy(Node nodeFolder, String newName)
			throws InternalErrorException, ItemAlreadyExistException,
			WrongDestinationException, RepositoryException {
		throw new InternalErrorException("GCUBEItem cannot be copied");
	}

	/* (non-Javadoc)
	 * @see org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem#internalMove(javax.jcr.Node)
	 */
	@Override
	public void internalMove(Node destinationFolderNode)
			throws ItemAlreadyExistException, InternalErrorException,
			RepositoryException {
		throw new InternalErrorException("GCUBEItem cannot be moved");
	}

	@Override
	public String getWorkflowId() throws InternalErrorException {
		return null;
	}

	@Override
	public void setWorkflowId(String id) throws InternalErrorException {
	}

	@Override
	public String getWorkflowStatus() throws InternalErrorException {
		return null;
	}

	@Override
	public void setWorkflowStatus(String status) throws InternalErrorException {
	}

	@Override
	public String getWorkflowData() throws InternalErrorException {
		return null;
	}

	@Override
	public void setWorkflowData(String data) throws InternalErrorException {

	}

	@Override
	public void removeChild(WorkspaceItem child) throws InternalErrorException,
	InsufficientPrivilegesException {

	}




}
