/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRenaming;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryType;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;

public class JCRAccountingEntryRenaming
extends JCRAccountingEntry
implements AccountingEntryRenaming {
    private static final String OLD_ITEM_NAME = "hl:oldItemName";
    private final String oldItemName;

    public JCRAccountingEntryRenaming(Node node) throws RepositoryException {
        super(node);
        this.oldItemName = node.getProperty(OLD_ITEM_NAME).getString();
    }

    public JCRAccountingEntryRenaming(String user, Calendar date, String oldItemName) {
        super(user, date);
        this.oldItemName = oldItemName;
    }

    public String getOldItemName() {
        return this.oldItemName;
    }

    @Override
    public void save(Node entryNode) throws RepositoryException {
        super.save(entryNode);
        entryNode.setProperty(OLD_ITEM_NAME, this.oldItemName);
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.RENAMING;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s oldItemName:%s]]", parentValue, AccountingEntryType.RENAMING, this.oldItemName);
    }
}

