package org.gcube.common.homelibrary.jcr.repository.external;

import java.io.IOException;
import java.io.InputStream;

import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCUBEStorage {

	private static Logger logger = LoggerFactory.getLogger(GCUBEStorage.class);
	//	private static IClient storage;
	private static String scope;
	private static String currentScope;


	static {
		try {

			currentScope = ScopeProvider.instance.get();
			scope = Utils.getRootScope(currentScope);

			ScopeProvider.instance.set(scope);
			logger.info("GCUBE Storage current scope : " + currentScope);

		} catch (Exception e) {
			logger.error("GCUBE Storage initialization failed",e);
		}
	}


	//	static {
	//		try {
	//
	//			String currentScope = ScopeProvider.instance.get();
	//			scope = Utils.getRootScope(currentScope);
	//
	//			ScopeProvider.instance.set(scope);
	//			logger.info("GCUBE Storage current scope : " + currentScope);
	//			storage = new StorageClient("org.gcube.portlets.user","home-library",
	//					"home-library",AccessType.SHARED, currentScope, false).getClient();
	//
	//			Handler.activateProtocol();
	//
	//		} catch (Exception e) {
	//			logger.error("GCUBE Storage initialization failed",e);
	//		}
	//	}


	public static IClient getStorage(String portalLogin){
		IClient storage = null;
		logger.trace("Calling GCUBEStorage from user: " + portalLogin);
		try {

			storage = new StorageClient("org.gcube.portlets.user","home-library",
					portalLogin, AccessType.SHARED, currentScope, false).getClient();

			Handler.activateProtocol();

		} catch (Exception e) {
			logger.error("GCUBE Storage initialization failed",e);
		}
		return storage;
	}


	public static String putStream(InputStream is, String remotePath, String portalLogin) throws RemoteBackendException {
		logger.trace("GCUBE Storage scope : " + scope);
		ScopeProvider.instance.set(scope);	

		logger.trace("putStream - remotePath: " + remotePath);

		IClient storage = getStorage(portalLogin);
		storage.put(true).LFile(is).RFile(remotePath);
		try {
			is.close();
			logger.trace("GCUBE Storage inputStream closed");
		} catch (IOException e) {
			logger.error("GCUBE Storage error during to close inputStream",e);
		}

		return getStorage(portalLogin).getUrl().RFile(remotePath);
	}



	public static String putStream(String is, String remotePath, String portalLogin) throws RemoteBackendException {
		logger.trace("putStream - remotePath: " + remotePath);
		ScopeProvider.instance.set(scope);
		logger.info("GCUBE Storage scope : " + scope);
		//		System.out.println("GCUBE Storage RFile path : " + remotePath);
		IClient storage = getStorage(portalLogin);
		storage.put(true).LFile(is).RFile(remotePath);
		//		try {
		//			is.close();
		//			logger.trace("GCUBE Storage inputStream closed");
		//		} catch (IOException e) {
		//			logger.error("GCUBE Storage error during to close inputStream",e);
		//		}

		return getStorage(portalLogin).getUrl().RFile(remotePath);
	}

	public static long getRemoteFileSize(String remotePath, String portalLogin) throws RemoteBackendException {
		logger.trace("getRemoteFileSize - remotePath: " + remotePath);
		ScopeProvider.instance.set(scope);
		logger.trace("GCUBE Storage RFile path : " + remotePath);
		IClient storage = getStorage(portalLogin);
		long size =storage.getSize().RFile(remotePath);
		return size;
	}

	//delete file	
	public static void removeRemoteFile(String remotePath, String portalLogin) throws RemoteBackendException {
		logger.trace("GCUBE Storage - removeRemoteFile - remotePath: " + remotePath);
		ScopeProvider.instance.set(scope);
		getStorage(portalLogin).remove().RFile(remotePath);
	}

	//delete folder
	public static void removeRemoteFolder(String remotePath, String portalLogin) throws RemoteBackendException {
		logger.trace("GCUBE Storage - storage.removeDir().RDir(" + remotePath + ")");
		ScopeProvider.instance.set(scope);
		IClient storage = getStorage(portalLogin);
		storage.removeDir().RDir(remotePath);
	}

	public static InputStream getRemoteFile(String remotePath, String portalLogin) {
		logger.trace("getRemoteFile - stream = storage.get().RFileAsInputStream(" + remotePath+ ")");
		ScopeProvider.instance.set(scope);
		InputStream stream = null;
		IClient storage = getStorage(portalLogin);
		try{
			stream = storage.get().RFileAsInputStream(remotePath);
		}catch (Exception e) {
			logger.error("no payload found in Storage for remotePath: " + remotePath );
		}
		return stream;
	}


	public static String getPublicLink(String remotePath, String portalLogin) {
		logger.trace("GCUBE Storage - Generate Public Link for " + remotePath);
		IClient storage = getStorage(portalLogin);
		String publicUrl = storage.getUrl().RFile(remotePath);
		return publicUrl;
	}

	//move dir
	public static void moveRemoteFolder(String oldPath, String newPath, String portalLogin) {
		logger.trace("GCUBE Storage - storage.moveDir().from(" + oldPath + ").to(" + newPath + ")");
		IClient storage = getStorage(portalLogin);
		storage.moveDir().from(oldPath).to(newPath);
	}

	//move file
	public static void moveRemoteFile(String oldPath, String newPath, String portalLogin) {
		logger.trace("GCUBE Storage - storage.moveFile().from(" + oldPath + ").to(" + newPath + ")");
		IClient storage = getStorage(portalLogin);
		storage.moveFile().from(oldPath).to(newPath);
	}

	//copy file
	public static void copyRemoteFile(String oldPath, String newPath, String portalLogin) {
		logger.trace("GCUBE Storage - storage.copyFile().from(" + oldPath + ").to(" + newPath + ")");
		IClient storage = getStorage(portalLogin);
		storage.copyFile().from(oldPath).to(newPath);
	}

	//use remotepath to access storage
	public static void createHardLink(String srcPath, String destPath, String portalLogin) {
		try{
			logger.trace("GCUBE Storage - storage.linkFile().from(" + srcPath + ").to(" + destPath + ")");
			IClient storage = getStorage(portalLogin);
			storage.linkFile().from(srcPath).to(destPath);
			//			System.out.println("created a hard link");
		}catch (Exception e) {
			logger.error("GCUBE Storage error creating a linkFile",e);
		}
	}

	//	public static InputStream getInputStream(URL url) throws IOException {
	//		
	//		URLConnection uc = url.openConnection();
	//		InputStream is=uc.getInputStream();
	//		return is;
	//	}

}
