package org.gcube.common.homelibrary.jcr.workspace.trash;


import java.util.ArrayList;
import java.util.List;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashFolder;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;

public class JCRWorkspaceTrashFolder extends JCRWorkspaceFolder implements WorkspaceTrashFolder{

	protected String identifier;
	public static final String NT_TRASH_ITEM 					= "nthl:trashItem";

	public JCRWorkspaceTrashFolder(JCRWorkspace workspace, Node node) throws RepositoryException {
		super(workspace, node);
		this.identifier = node.getIdentifier();
	}


	@Override
	public WorkspaceTrashItem getTrashItemById(String id)
			throws InternalErrorException {
		Session session = null;
		Node trashNode = null;
		JCRWorkspaceTrashItem trashItem = null;
		try {
			session = JCRRepository.getSession();

			trashNode = session.getNodeByIdentifier(id);

			if (trashNode.getPrimaryNodeType().getName().equals("nthl:trashItem")){
				try{
					trashItem = new JCRWorkspaceTrashItem(workspace, trashNode);

				}catch (Exception e) {
					throw new InternalErrorException("Trash not found " + e);
				}	
			}
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
		return trashItem;
	}

	
	@Override
	public List<WorkspaceTrashItem> listTrashItems() throws InternalErrorException, ItemNotFoundException {
		Session session = null;
		Node node = null;
		List<WorkspaceTrashItem> children = null;
		try {
			session = JCRRepository.getSession();
			children = new ArrayList<WorkspaceTrashItem>();

			node = session.getNodeByIdentifier(identifier);

			NodeIterator trashNodes = node.getNodes();
			while (trashNodes.hasNext()){

				Node trashNode = trashNodes.nextNode();
				if (trashNode.getPrimaryNodeType().getName().equals(NT_TRASH_ITEM)){
					WorkspaceTrashItem trashItem = (WorkspaceTrashItem) workspace.getItem(trashNode.getIdentifier());
					//					System.out.println("Found: " + trashItem.getPath());
					children.add(trashItem);
				}
			}

		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
		return children;
	}



		public List<? extends WorkspaceItem> listTrash() throws InternalErrorException {
			Session session = null;
			Node node = null;
			try {
				session = JCRRepository.getSession();
	
				node = session.getNodeByIdentifier(identifier);
				WorkspaceItem item = workspace.getWorkspaceItem(node);
	
				//			System.out.println(item.getPath());
				List<? extends WorkspaceItem> children = item.getChildren();

				for ( WorkspaceItem child : children){
	
//					System.out.println("*** " + child.getPath() + " - child.getType(): " + child.getType());
//					System.out.println("-> id " + child.getId() );
//					System.out.println("\n");
				}
				try{
					//				removeRemoteContent(node, getType());
				}catch (Exception e) {
					logger.warn(node.getName() + " payload not available", e);
				}
				//			node.remove();
				//			session.save();
			} catch (RepositoryException e) {
				throw new InternalErrorException(e);
			} finally {
				session.logout();
			}
			return null;
		}

	@Override
	public List<String> emptyTrash() throws InternalErrorException {

		//		listTrash();
		Session session = null;
		Node trashNode = null;
		try {
			session = JCRRepository.getSession();
			trashNode = session.getNodeByIdentifier(identifier);

			NodeIterator children = trashNode.getNodes();

			while (children.hasNext()){
				Node child = children.nextNode();
//				System.out.println("child.getPath(): "+  child.getPath() + " - child.getPrimaryNodeType().getName(): "+ child.getPrimaryNodeType().getName());
				if (child.getPrimaryNodeType().getName().equals("nthl:trashItem")){
					try{
						JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(workspace, child);
						trashItem.deletePermanently();
					}catch (Exception e) {
						throw new InternalErrorException(e);
					}	

//					child.remove();
					//					System.out.println("deletePermanently");
				}
			}


			//			trashNode.remove();
			session.save();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

		//		listTrash();

		return null;
	}

	@Override
	public List<String> restoreAll() throws InternalErrorException {

		//		listTrash();

		Session session = null;
		Node trashNode = null;
		try {
			session = JCRRepository.getSession();
			trashNode = session.getNodeByIdentifier(identifier);

			NodeIterator children = trashNode.getNodes();

			while (children.hasNext()){
				Node child = children.nextNode();

//				System.out.println("child.getPath(): "+  child.getPath() + " - child.getPrimaryNodeType().getName(): "+ child.getPrimaryNodeType().getName());
				if (child.getPrimaryNodeType().getName().equals("nthl:trashItem")){
					try{
						JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(workspace, child);
						trashItem.restore();
					}catch (Exception e) {
						throw new InternalErrorException(e);
					}	

				}
			}

			session.save();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}

		//		listTrash();
		return null;
	}

	@Override
	public WorkspaceItemType getType() {
		return WorkspaceItemType.TRASH_FOLDER;
	}





}
