/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.trash;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRWorkspaceTrashItem
extends JCRWorkspaceFolder
implements WorkspaceTrashItem {
    protected static final String CONTENT = "jcr:content";
    protected static final String DELETE_DATE = "hl:deletedTime";
    protected static final String DELETE_USER = "hl:deletedBy";
    protected static final String ORIGINAL_PARENT_ID = "hl:originalParentId";
    protected static final String ORIGINAL_PATH = "hl:deletedFrom";
    protected static final String NAME = "hl:name";
    protected static final String MIME_TYPE = "hl:mimeType";
    protected static final String LENGTH = "hl:length";
    protected static final String IS_FOLDER = "hl:isFolder";
    private final JCRWorkspace workspace;
    private String identifier;
    private Calendar deletedTime;
    private String originalParentId;
    private String deletedBy;
    private String mimeType;
    private long length;
    private boolean isFolder;
    private String deletedFrom;
    private String trashId;

    public JCRWorkspaceTrashItem(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
        this.identifier = node.getIdentifier();
        this.workspace = workspace;
        this.trashId = workspace.getTrashId();
        PropertyIterator properties = node.getProperties(new String[]{"hl:*"});
        while (properties.hasNext()) {
            String propertyName;
            Property property = properties.nextProperty();
            switch (propertyName = property.getName()) {
                case "hl:deletedTime": {
                    this.deletedTime = property.getDate();
                    break;
                }
                case "hl:deletedBy": {
                    this.deletedBy = property.getString();
                    break;
                }
                case "hl:deletedFrom": {
                    this.deletedFrom = property.getString();
                    break;
                }
                case "hl:originalParentId": {
                    this.originalParentId = property.getString();
                    break;
                }
                case "hl:isFolder": {
                    this.isFolder = property.getBoolean();
                    break;
                }
                case "hl:mimeType": {
                    this.mimeType = property.getString();
                    break;
                }
                case "hl:length": {
                    this.length = property.getLong();
                    break;
                }
            }
        }
    }

    public JCRWorkspaceTrashItem(JCRWorkspace workspace, Node node, String name, String description, Calendar date, String portalLogin, String originalParentId, String mimeType, long length, boolean isFolder, String originalPath) throws RepositoryException {
        super(workspace, node, name, description);
        this.identifier = node.getIdentifier();
        this.workspace = workspace;
        this.deletedBy = portalLogin;
        this.deletedTime = date;
        this.originalParentId = originalParentId;
        this.deletedFrom = originalPath;
        this.mimeType = mimeType;
        this.length = length;
        this.isFolder = isFolder;
        node.setProperty(NAME, name);
        node.setProperty(DELETE_DATE, Calendar.getInstance());
        node.setProperty(DELETE_USER, portalLogin);
        node.setProperty(ORIGINAL_PARENT_ID, originalParentId);
        node.setProperty(ORIGINAL_PATH, originalPath);
        node.setProperty(MIME_TYPE, mimeType);
        node.setProperty(LENGTH, length);
        node.setProperty(IS_FOLDER, isFolder);
    }

    public void restore() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        Node node = null;
        try {
            node = session.getNodeByIdentifier(this.identifier).getNode(this.getName());
            Node originalParentNode = null;
            try {
                originalParentNode = session.getNodeByIdentifier(this.originalParentId);
            }
            catch (Exception e) {
                logger.warn("The original Parent Node does not exist anymore");
            }
            String parentId = null;
            if (originalParentNode != null) {
                parentId = originalParentNode.getParent().getIdentifier();
            }
            if (originalParentNode != null && !parentId.equals(this.trashId)) {
                try {
                    this.workspace.moveItem(node.getIdentifier(), this.originalParentId);
                }
                catch (Exception e) {
                    try {
                        String time = JCRWorkspaceTrashItem.timeStampRename();
                        this.setName(node, time + "_" + this.getName());
                        this.workspace.moveItem(node.getIdentifier(), this.originalParentId);
                    }
                    catch (Exception e1) {
                        throw new InternalErrorException((Throwable)e1);
                    }
                }
            } else {
                try {
                    this.workspace.moveItem(node.getIdentifier(), this.workspace.getRoot().getId());
                }
                catch (Exception e1) {
                    throw new InternalErrorException("The file has been restored in the root");
                }
            }
            session.getNodeByIdentifier(this.identifier).remove();
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RemoteBackendException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private static String timeStampRename() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HHmmssss_");
        String formattedDate = sdf.format(date);
        return formattedDate;
    }

    public void deletePermanently() throws InternalErrorException {
        Session session = null;
        Node node = null;
        try {
            session = JCRRepository.getSession();
            node = session.getNodeByIdentifier(this.identifier);
            JCRWorkspaceItem item = this.workspace.getWorkspaceItem(node);
            logger.debug("deletePermanently node: " + item.getName());
            try {
                GCUBEStorage.removeRemoteFolder(node.getPath(), this.workspace.getOwner().getPortalLogin());
            }
            catch (Exception e) {
                logger.warn("Error removing " + node.getPath() + " from storage", (Throwable)e);
            }
            node.remove();
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.TRASH_ITEM;
    }

    public long getLength() throws InternalErrorException {
        return this.length;
    }

    public String getMimeType() throws InternalErrorException {
        return this.mimeType;
    }

    public String getDeletedFrom() {
        return this.deletedFrom;
    }

    public String getOriginalParentId() {
        return this.originalParentId;
    }

    public Calendar getDeletedTime() {
        return this.deletedTime;
    }

    public String getDeletedBy() {
        return this.deletedBy;
    }

    @Override
    public boolean isFolder() {
        return this.isFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() throws InternalErrorException {
        String name = null;
        Session session = null;
        Node node = null;
        try {
            session = JCRRepository.getSession();
            node = session.getNodeByIdentifier(this.identifier);
            name = node.getProperty(NAME).getString();
        }
        catch (RepositoryException e) {
        }
        finally {
            session.logout();
        }
        return name;
    }

    public void setName(Node node, String name) throws RepositoryException {
        try {
            node.setProperty(NAME, name);
            node.getSession().save();
        }
        catch (Exception e) {
            logger.error("Error setting a new name to WorkspaceTrashItem: " + e);
        }
    }

    @Override
    public void removeChild(WorkspaceItem child) throws InternalErrorException, InsufficientPrivilegesException {
    }
}

