/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.usermanager;

import com.thoughtworks.xstream.XStream;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRGroup
implements GCubeGroup {
    private Logger logger = LoggerFactory.getLogger(JCRGroup.class);
    public static String url;
    public String name;
    public Group group;

    public JCRGroup(String name) throws InternalErrorException {
        this.name = name;
        url = JCRRepository.url;
    }

    public String getName() {
        return this.name;
    }

    public boolean removeMembers(List<String> usersList) throws InternalErrorException {
        try {
            this.updateGroup(null, usersList);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean addMembers(List<String> users) throws InternalErrorException {
        try {
            this.updateGroup(users, null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean addMember(final String user) throws InternalErrorException {
        try {
            this.updateGroup((List<String>)new ArrayList<String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add(user);
                }
            }, null);
        }
        catch (InternalErrorException e) {
            return false;
        }
        return true;
    }

    public boolean removeMember(final String user) throws InternalErrorException {
        try {
            this.updateGroup(null, (List<String>)new ArrayList<String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add(user);
                }
            });
        }
        catch (InternalErrorException e) {
            return false;
        }
        return true;
    }

    public boolean isMember(String member) throws InternalErrorException {
        try {
            List<String> members = this.getMembers();
            if (members.contains(member)) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        return false;
    }

    public List<String> getMembers() throws InternalErrorException {
        GetMethod getMethod = null;
        List users = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/GroupMembershipServlet?groupName=" + this.name);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            XStream xstream = new XStream();
            users = (List)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return users;
    }

    public void updateGroup(List<String> members, List<String> membersToDelete) throws InternalErrorException {
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            if (members != null) {
                StringBuilder listMembers = new StringBuilder();
                for (String member : members) {
                    listMembers.append("&member=");
                    listMembers.append(member);
                }
                this.logger.debug("URL: " + url + "/UpdateGroupServlet?groupName=" + this.name + listMembers);
                getMethod = new GetMethod(url + "/UpdateGroupServlet?groupName=" + this.name + listMembers);
            }
            if (membersToDelete != null) {
                StringBuilder listMembersToDelete = new StringBuilder();
                for (String member : membersToDelete) {
                    listMembersToDelete.append("&memberToDelete=");
                    listMembersToDelete.append(member);
                }
                this.logger.debug("URL: " + url + "/UpdateGroupServlet?groupName=" + this.name + listMembersToDelete);
                getMethod = new GetMethod(url + "/UpdateGroupServlet?groupName=" + this.name + listMembersToDelete);
            }
            httpClient.executeMethod(getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error updating Group " + this.name, (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public String getDisplayName() throws InternalErrorException {
        String displayName;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/GetDisplayNameServlet?groupName=" + this.name);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            XStream xstream = new XStream();
            displayName = (String)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDisplayName(String displayName) throws InternalErrorException {
        boolean flag;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/SetDisplayNameServlet?groupName=" + this.name + "&displayName=" + displayName);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            flag = true;
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return flag;
    }
}

