/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.shortner;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlEncoderUtil {
    public static String charset = "UTF-8";
    public static Logger logger = LoggerFactory.getLogger(UrlEncoderUtil.class);

    public static String encodeQuery(String ... parameters) {
        String query = "";
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            try {
                query = String.valueOf(query) + URLEncoder.encode(string, charset) + "&";
            }
            catch (UnsupportedEncodingException e) {
                logger.error("UnsupportedEncodingException ", (Throwable)e);
                return query;
            }
            ++n2;
        }
        return UrlEncoderUtil.removeLastChar(query);
    }

    public static String encodeQuery(Map<String, String> parameters) {
        String query = "";
        if (parameters == null) {
            return query;
        }
        for (String key : parameters.keySet()) {
            try {
                query = String.valueOf(query) + String.format(String.valueOf(key) + "=%s", URLEncoder.encode(parameters.get(key), charset)) + "&";
            }
            catch (UnsupportedEncodingException e) {
                logger.error("UnsupportedEncodingException ", (Throwable)e);
                return query;
            }
        }
        return UrlEncoderUtil.removeLastChar(query);
    }

    public static String removeLastChar(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() > 0) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }
}

