package org.gcube.common.homelibrary.jcr.workspace.search;

import java.util.Calendar;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.search.SearchFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;

public class JCRSearchFolder implements SearchFolder {

	private static final String ROOT			= "/";
	private static final String SHARED 			= "nthl:workspaceSharedItem";

	private final String id;
	private Calendar creationDate;
	private Calendar lastModified;
	private String owner;
	private final String type;
	private boolean isVreFolder;
	private boolean isShared;

	protected String name;
	private String displayName;

	public JCRSearchFolder(Node node, String name) throws RepositoryException{
		
		this.id = node.getIdentifier();
		
		String[] nameGlobs = {JCRWorkspaceItem.CREATED, JCRWorkspaceItem.LAST_MODIFIED,JCRWorkspaceItem.ISVREFOLDER, JCRWorkspaceItem.DISPLAY_NAME, JCRWorkspaceItem.PORTAL_LOGIN };
		PropertyIterator properties = node.getProperties(nameGlobs);
		while (properties.hasNext()){
			Property propery = properties.nextProperty();
			switch (propery.getName()) {
			
			case JCRWorkspaceItem.CREATED:
				this.creationDate = propery.getDate();
				break;
				
			case JCRWorkspaceItem.LAST_MODIFIED:
				this.lastModified = propery.getDate();
				break;

			case JCRWorkspaceItem.ISVREFOLDER:
				this.isVreFolder = propery.getBoolean();
				break;
							
			case JCRWorkspaceItem.DISPLAY_NAME:
				this.displayName = propery.getString();
				break;
				
			case JCRWorkspaceItem.PORTAL_LOGIN:				
				this.owner = propery.getString();
				break;
			
			default:
				break;
			}
		}
	
		if (isVreFolder){
			try{
				this.name = node.getProperty(JCRWorkspaceItem.DISPLAY_NAME).getString();
			}catch (Exception e) {	this.name = name;}
		}else
			this.name = name;
			
//		this.creationDate = node.getProperty(JCRWorkspaceItem.CREATED).getDate();
//		this.lastModified = node.getProperty(JCRWorkspaceItem.LAST_MODIFIED).getDate();
//
//		try{
//			this.isVreFolder = node.getProperty(JCRWorkspaceItem.ISVREFOLDER).getBoolean();
//			if (isVreFolder){
//				try{
//					this.name = node.getProperty(JCRWorkspaceItem.DISPLAY_NAME).getString();
//				}catch (Exception e) {}
//			}
//				
//		}catch (Exception e) {
//			this.isVreFolder = false;
//		}
//
//		Node nodeOwner = null;
//		try{
//			nodeOwner = node.getNode(JCRWorkspaceItem.OWNER);
//		}catch (Exception e) {}

		try {
			this.isShared = isShared(node);
		} catch (InternalErrorException e) {}

//		this.owner = nodeOwner.getProperty(JCRWorkspaceItem.PORTAL_LOGIN).getString();
		this.type = node.getPrimaryNodeType().getName();
	}


	@Override
	public String getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public Calendar getCreationDate() {
		return creationDate;
	}

	@Override
	public Calendar getLastModified() {		
		return lastModified;
	}

	@Override
	public String getOwner() {
		return owner;
	}

	@Override
	public boolean isVreFolder() {
		return isVreFolder;
	}
	
	@Override
	public boolean isShared() {
		return isShared;
	}

	@Override
	public WorkspaceItemType getType() {

		if (type.equals(JCRWorkspace.NT_WORKSPACE_SHARED_FOLDER))
			return WorkspaceItemType.SHARED_FOLDER;

		return WorkspaceItemType.FOLDER;

	}


	private boolean isShared(Node node) throws InternalErrorException, AccessDeniedException, ItemNotFoundException, RepositoryException {			
		return (getIdSharedFolder(node) != null)?true:false;
	}

	public String getIdSharedFolder(Node node) throws InternalErrorException, AccessDeniedException, ItemNotFoundException, RepositoryException {
		if (node.getParent().getPath().equals(ROOT))
			return null;

		if (node.getPrimaryNodeType().getName().equals(SHARED)) 
			return node.getIdentifier();

		return  getIdSharedFolder(node.getParent());
	}


}
