package org.gcube.common.homelibrary.jcr.workspace.search;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.search.SearchFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;



public class JCRSearchFolderItem extends JCRSearchFolder implements SearchFolderItem {

	protected static final String CONTENT			= "jcr:content";
	protected static final String DATA 	  			= "jcr:data";
	private static final String  MIME_TYPE         	= "jcr:mimeType";
	private static final String SIZE				= "hl:size";

	private long size;
	private String mimeType;
	private final FolderItemType folderItemType;


	public JCRSearchFolderItem(Node node, FolderItemType type, String name) throws RepositoryException  {
		super(node,name);

		this.folderItemType = type;
		
		String[] nameGlobs = {MIME_TYPE, SIZE};
		
		try {
			//			Node contentNode = node.getNode(CONTENT);
			//			this.mimeType = contentNode.getProperty(MIME_TYPE).getString();
			//			this.size = contentNode.getProperty(SIZE).getLong();	

			PropertyIterator properties = node.getNode(CONTENT).getProperties(nameGlobs);
			while (properties.hasNext()){
				Property propery = properties.nextProperty();
				switch (propery.getName()) {

				case MIME_TYPE:
					this.mimeType = propery.getString();
					break;

				case SIZE:
					this.size = propery.getLong();
					break;

				default:
					break;
				}

			}

		} catch (RepositoryException e) {

		}

	}


	@Override
	public long getSize() {
		return size;
	}

	@Override
	public String getMimeType() {
		return mimeType;
	}

	@Override
	public WorkspaceItemType getType() {		
		return WorkspaceItemType.FOLDER_ITEM;	
	}

	@Override
	public FolderItemType getFolderItemType() {
		return folderItemType;
	}


}
