package org.gcube.common.homelibrary.jcr.workspace.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.AquaMapsItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.Image;
import org.gcube.common.homelibrary.home.workspace.folder.items.Query;
import org.gcube.common.homelibrary.home.workspace.folder.items.Report;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.common.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.DocumentMetadata;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.common.homelibrary.home.workspace.folder.items.ts.TimeSeriesInfo;



public class HomeLibraryImporter {

	public static int errors = 0;
	public static int notImported = 0;
	
	public static void copyItem(Workspace newWorkspace, WorkspaceItem oldRoot, 
			String newRoot) throws InternalErrorException,
			InsufficientPrivilegesException, ItemAlreadyExistException,
			WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException, WrongItemTypeException {

		if(oldRoot.getChildren() == null)
			return;
		
		for(WorkspaceItem childItem : oldRoot.getChildren()) {
			WorkspaceItem item = createJCRWorkspaceItem(newWorkspace, newRoot, childItem);
			if (item != null)
				copyItem(newWorkspace, childItem, item.getId());
		}
	}

	public static WorkspaceItem createJCRWorkspaceItem(Workspace newWorkspace, String destinationFolderId,
			WorkspaceItem oldItem) throws InsufficientPrivilegesException,
			ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException,
			WorkspaceFolderNotFoundException, InternalErrorException, WrongItemTypeException {

		switch (oldItem.getType()) {
			case FOLDER: 
				try {
					return newWorkspace.createFolder(oldItem.getName(), oldItem.getDescription(), destinationFolderId);
				} catch (ItemAlreadyExistException e) {
					System.err.println("Item " + oldItem.getName() + " already exists");
					return newWorkspace.find(oldItem.getName(),destinationFolderId);
//					return newWorkspace.createFolder(oldItem.getName() + scope, 
//							oldItem.getDescription(),
//							destinationFolderId);
				}
			case FOLDER_ITEM:
				return createJCRWorkspaceFolderItem(newWorkspace, destinationFolderId, (FolderItem)oldItem);
			default :
				return null;
		}
	}

	public static WorkspaceItem createJCRWorkspaceFolderItem(Workspace newWorkspace, String destinationFolderId,
			FolderItem oldItem)  {

		try {
			switch (oldItem.getFolderItemType()) {
				case EXTERNAL_FILE:
					ExternalFile file = (ExternalFile)oldItem;
					try {
						return newWorkspace.createExternalFile(file.getName(), file.getDescription(), 
								file.getMimeType(), file.getData(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
//						return newWorkspace.createExternalFile(file.getName() + scope, file.getDescription(), 
//								file.getMimeType(), file.getData(), destinationFolderId);
						System.err.println("File found " + file.getName());
					}

				case EXTERNAL_IMAGE:
					ExternalImage image = (ExternalImage)oldItem;
					try {
						return newWorkspace.createExternalImage(image.getName(), image.getDescription(),
								image.getMimeType(), image.getData(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + image.getName());
//						return newWorkspace.createExternalImage(image.getName() + scope, image.getDescription(),
//								image.getMimeType(), image.getData(), destinationFolderId);
					}
				case EXTERNAL_PDF_FILE:
					ExternalPDFFile pdfFile = (ExternalPDFFile)oldItem;
					try {
						return newWorkspace.createExternalPDFFile(pdfFile.getName(), pdfFile.getDescription(), 
								pdfFile.getMimeType(), pdfFile.getData(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + pdfFile.getName());
//						return newWorkspace.createExternalPDFFile(pdfFile.getName() + scope, pdfFile.getDescription(), 
//								pdfFile.getMimeType(), pdfFile.getData(), destinationFolderId);
					}
				case EXTERNAL_URL:
					ExternalUrl url = (ExternalUrl)oldItem;
					try {
						return newWorkspace.createExternalUrl(url.getName(), url.getDescription(), url.getUrl(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + url.getName());
//						return newWorkspace.createExternalUrl(url.getName() + scope,
//								url.getDescription(), url.getUrl(), destinationFolderId);
					}
				case AQUAMAPS_ITEM:
					AquaMapsItem aquaMapsItem = (AquaMapsItem)oldItem;
					List<Image> images = aquaMapsItem.getImages();
					HashMap<String, InputStream> map = new HashMap<String,InputStream>();
					for (Image img : images) {
						map.put(img.getName(), img.getData());
					}
					try {
						return newWorkspace.createAquaMapsItem(aquaMapsItem.getName(), aquaMapsItem.getDescription(), aquaMapsItem.getMapName(), aquaMapsItem.getMapType(), aquaMapsItem.getAuthor(), aquaMapsItem.getNumberOfSpecies(),
								aquaMapsItem.getBoundingBox(), aquaMapsItem.getPsoThreshold(), aquaMapsItem.getNumberOfGeneratedImages(), aquaMapsItem.getMetadata().getData(), map, destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + aquaMapsItem.getName());
//						return newWorkspace.createAquaMapsItem(aquaMapsItem.getName() + scope,
//								aquaMapsItem.getDescription(), aquaMapsItem.getMapName(), aquaMapsItem.getMapType(), aquaMapsItem.getAuthor(), aquaMapsItem.getNumberOfSpecies(),
//								aquaMapsItem.getBoundingBox(), aquaMapsItem.getPsoThreshold(), aquaMapsItem.getNumberOfGeneratedImages(), aquaMapsItem.getMetadata().getData(), map, destinationFolderId);
					}
				case GCUBE_ITEM:
					GCubeItem gcubeItem = (GCubeItem)oldItem;
					
					try {
						return newWorkspace.createGcubeItem(gcubeItem.getName(), gcubeItem.getDescription(), gcubeItem.getScopes(), gcubeItem.getCreator(), gcubeItem.getItemType(), gcubeItem.getItemProperties(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("object found" + gcubeItem.getName());
//						return newWorkspace.createAquaMapsItem(aquaMapsItem.getName() + scope,
//								aquaMapsItem.getDescription(), aquaMapsItem.getMapName(), aquaMapsItem.getMapType(), aquaMapsItem.getAuthor(), aquaMapsItem.getNumberOfSpecies(),
//								aquaMapsItem.getBoundingBox(), aquaMapsItem.getPsoThreshold(), aquaMapsItem.getNumberOfGeneratedImages(), aquaMapsItem.getMetadata().getData(), map, destinationFolderId);
					}
				case TIME_SERIES:
					TimeSeries ts = (TimeSeries)oldItem;
					TimeSeriesInfo infos = ts.getTimeSeriesInfo();
					try {
						return newWorkspace.createTimeSeries(ts.getName(), ts.getDescription(), infos.getId(), infos.getTitle(), infos.getCreator(),
								infos.getDescription(), infos.getCreationDate(), infos.getPublisher(), infos.getSourceId(), infos.getSourceName(),
								infos.getRights(), infos.getDimension(), ts.getHeaderLabels(), ts.getCompressedData(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + ts.getName());
//						return newWorkspace.createTimeSeries(ts.getName() + scope, ts.getDescription(), infos.getId(), infos.getTitle(), infos.getCreator(),
//								infos.getDescription(), infos.getCreationDate(), infos.getPublisher(), infos.getSourceId(), infos.getSourceName(),
//								infos.getRights(), infos.getDimension(), ts.getHeaderLabels(), ts.getCompressedData(), destinationFolderId);
					}
				case QUERY:
					Query query = (Query)oldItem;
					try {
						return newWorkspace.createQuery(query.getName(), query.getDescription(), query.getQuery(), query.getQueryType(),
								destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + query.getName());
//						return newWorkspace.createQuery(query.getName() + scope,
//								query.getDescription(), query.getQuery(), query.getQueryType(),
//								destinationFolderId);
					}
				case REPORT:
					Report report = (Report)oldItem;
					try {
						return newWorkspace.createReport(report.getName(), report.getDescription(), report.getCreated(), report.getLastEdit(), report.getAuthor(),
								report.getLastEditBy(), report.getTemplateName(), report.getNumberOfSections(), report.getStatus(), report.getData(),
								destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + oldItem.getName());
//						return newWorkspace.createReport(report.getName() + scope,
//								report.getDescription(), report.getCreated(), report.getLastEdit(), report.getAuthor(),
//								report.getLastEditBy(), report.getTemplateName(), report.getNumberOfSections(), report.getStatus(), report.getData(),
//								destinationFolderId);
					}
				case REPORT_TEMPLATE:
					ReportTemplate reportTemplate = (ReportTemplate)oldItem;
					try {
						return newWorkspace.createReportTemplate(reportTemplate.getName(), reportTemplate.getDescription(), reportTemplate.getCreated(), reportTemplate.getLastEdit(), reportTemplate.getAuthor(),
								reportTemplate.getLastEditBy(), reportTemplate.getNumberOfSections(), reportTemplate.getStatus(), reportTemplate.getData(),
								destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + reportTemplate.getName());
//						return newWorkspace.createReportTemplate(reportTemplate.getName() + scope,
//								reportTemplate.getDescription(), reportTemplate.getCreated(), reportTemplate.getLastEdit(), reportTemplate.getAuthor(),
//								reportTemplate.getLastEditBy(), reportTemplate.getNumberOfSections(), reportTemplate.getStatus(), reportTemplate.getData(),
//								destinationFolderId);
					}
				case WORKFLOW_REPORT:
					WorkflowReport workflowReport = (WorkflowReport)oldItem;
					try {
						return newWorkspace.createWorkflowReport(workflowReport.getName(), workflowReport.getDescription(), workflowReport.getWorkflowId(), workflowReport.getWorkflowStatus(),
								workflowReport.getWorkflowData(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + workflowReport.getName());
//						return newWorkspace.createWorkflowReport(workflowReport.getName() + scope,
//								workflowReport.getDescription(), workflowReport.getWorkflowId(), workflowReport.getWorkflowStatus(),
//								workflowReport.getWorkflowData(), destinationFolderId);
					}
				case WORKFLOW_TEMPLATE:
					WorkflowTemplate w = (WorkflowTemplate)oldItem;
					try {
						return newWorkspace.createWorkflowTemplate(w.getName(), w.getDescription(), w.getWorkflowId(), w.getWorkflowStatus(),
								w.getWorkflowData(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + w.getName());
//						return newWorkspace.createWorkflowTemplate(w.getName() + scope,
//								w.getDescription(), w.getWorkflowId(), w.getWorkflowStatus(),
//								w.getWorkflowData(), destinationFolderId);
					}
				case DOCUMENT: {
					Document document = (Document)oldItem; 
					if (document.getData() == null) {
						System.err.println("DATA is null");
						return null;
					}
					HashMap<String,String> mapMetadata = new HashMap<String,String>();
					for(Entry<String, DocumentMetadata> entry : document.getMetadata().entrySet()) {
						mapMetadata.put(entry.getKey(), entry.getValue().getXML());
					}
					try {
						return newWorkspace.createDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(),
								document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + document.getName());
//						return newWorkspace.createDocument(document.getName() + scope,
//								document.getDescription(), document.getURI(), document.getMimeType(),
//								document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
					}
				}
				case IMAGE_DOCUMENT: {
					ImageDocument document = (ImageDocument)oldItem;
					HashMap<String,String> mapMetadata = new HashMap<String,String>();
					for(Entry<String, DocumentMetadata> entry : document.getMetadata().entrySet()) {
						mapMetadata.put(entry.getKey(), entry.getValue().getXML());
					}
					try {
						return newWorkspace.createImageDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(),
								document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + document.getName());
//						return newWorkspace.createImageDocument(document.getName() + scope,
//								document.getDescription(), document.getURI(), document.getMimeType(),
//								document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
					}
				}
				case PDF_DOCUMENT: {
					PDFDocument document = (PDFDocument)oldItem;
					HashMap<String,String> mapMetadata = new HashMap<String,String>();
					for(Entry<String, DocumentMetadata> entry : document.getMetadata().entrySet()) {
						mapMetadata.put(entry.getKey(), entry.getValue().getXML());
					}
					try {
						return newWorkspace.createPDFDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(),
								document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + document.getName());
//						return newWorkspace.createPDFDocument(document.getName() + scope,
//								document.getDescription(), document.getURI(), document.getMimeType(),
//								document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
					}
				}
				
				case URL_DOCUMENT: {
					UrlDocument document = (UrlDocument)oldItem;
					HashMap<String,String> mapMetadata = new HashMap<String,String>();
					for(Entry<String, DocumentMetadata> entry : document.getMetadata().entrySet()) {
						mapMetadata.put(entry.getKey(), entry.getValue().getXML());
					}
					try {
						return newWorkspace.createUrlDocument(document.getName(), document.getDescription(), document.getURI(), document.getMimeType(),
								document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + document.getName());
//						return newWorkspace.createUrlDocument(document.getName() + scope,
//								document.getDescription(), document.getURI(), document.getMimeType(),
//								document.getData(), mapMetadata, document.getAnnotation(), document.getCollectionName(), destinationFolderId);
					}
				}
				case METADATA: {
					Metadata metadata = (Metadata)oldItem;
					try {
						return newWorkspace.createMetadata(metadata.getName(), metadata.getDescription(), metadata.getURI(),
								metadata.getSchema(), metadata.getLanguage(), metadata.getData(), metadata.getCollectionName(), destinationFolderId);
					} catch (ItemAlreadyExistException e) {
						System.err.println("File found " + metadata.getName());
//						return newWorkspace.createMetadata(metadata.getName() + scope,
//								metadata.getDescription(), metadata.getURI(), metadata.getSchema(),
//								metadata.getLanguage(), metadata.getData(), metadata.getCollectionName(), destinationFolderId);

					}

				}
				default:
					System.err.println("ITEM is not been imported " + oldItem.getFolderItemType());
					notImported ++;
					return null;
			}
		} catch (Exception e) {
			try {
				System.err.println("Item "+oldItem.getName() +" not imported");
			} catch (InternalErrorException e1) {
				
			}

			errors ++;
//			notImported ++;
	
			return null;
		}
	}

}
