/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;

public class JCRGCubeItem
extends JCRWorkspaceItem
implements GCubeItem {
    private static final String SCOPES = "hl:scopes";
    private static final String CREATOR = "hl:creator";
    private static final String ITEM_TYPE = "hl:itemType";
    private static final String PROPERTIES = "hl:properties";
    private static final String PROPERTY = "hl:property";
    private List<String> scopes;
    private String itemType;
    private String creator;
    private Map<String, String> properties = null;
    protected String identifier;

    public JCRGCubeItem(JCRWorkspace workspace, Node node, String name, String description, List<String> scopes, String creator, String itemType, Map<String, String> properties) throws RepositoryException, ItemNotFoundException {
        super(workspace, node, name, description);
        Validate.notNull(scopes, (String)"scopes must be not null");
        Validate.notNull((Object)creator, (String)"creator must be not null");
        Validate.notNull((Object)itemType, (String)"item type must be not null");
        this.identifier = node.getIdentifier();
        this.scopes = scopes;
        this.creator = creator;
        this.itemType = itemType;
        this.properties = properties;
        node.setProperty(CREATOR, creator);
        node.setProperty(ITEM_TYPE, itemType);
        node.setProperty(SCOPES, scopes.toArray(new String[0]));
        if (properties != null) {
            this.setProperties(node, properties);
        }
    }

    public JCRGCubeItem(JCRWorkspace workspace, Node node) throws RepositoryException {
        super(workspace, node);
        this.identifier = node.getIdentifier();
        this.scopes = new ArrayList<String>();
        for (Value value : node.getProperty(SCOPES).getValues()) {
            this.scopes.add(value.getString());
        }
        this.creator = node.getProperty(CREATOR).getString();
        this.itemType = node.getProperty(ITEM_TYPE).getString();
        this.properties = node.hasProperty(PROPERTIES) && node.getProperty(PROPERTIES) != null ? (Map)new XStream().fromXML(node.getProperty(PROPERTIES).getString()) : Collections.emptyMap();
    }

    public void setItemProperties(Map<String, String> properties) throws InternalErrorException {
        this.properties = properties;
        Session session = null;
        Node node = null;
        try {
            session = JCRRepository.getSession();
            node = session.getNodeByIdentifier(this.identifier);
            if (properties != null) {
                this.setProperties(node, properties);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private void setProperties(Node node, Map<String, String> properties) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        Node propertiesNode;
        try {
            propertiesNode = node.getNode(PROPERTY);
        }
        catch (Exception e) {
            propertiesNode = node.addNode(PROPERTY);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            propertiesNode.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public WorkspaceItemType getType() {
        return WorkspaceItemType.FOLDER_ITEM;
    }

    public List<? extends WorkspaceItem> getChildren() throws InternalErrorException {
        return null;
    }

    public List<String> getScopes() throws InternalErrorException {
        return this.scopes;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getCreator() {
        return this.creator;
    }

    public Map<String, String> getItemProperties() throws InternalErrorException {
        HashMap<String, String> propertiesList = new HashMap<String, String>();
        Session session = null;
        Node node = null;
        try {
            PropertyIterator prop;
            Object value;
            session = JCRRepository.getSession();
            node = session.getNodeByIdentifier(this.identifier);
            PropertyIterator prope = node.getNode(PROPERTY).getProperties();
            while (prope.hasNext()) {
                Property property = prope.nextProperty();
                String key = property.getName();
                value = property.getString();
            }
            try {
                prop = node.getNode(PROPERTY).getProperties();
            }
            catch (Exception e) {
                value = this.properties;
                session.logout();
                return value;
            }
            while (prop.hasNext()) {
                Property property = prop.nextProperty();
                String key = property.getName();
                String value2 = property.getString();
                propertiesList.put(key, value2);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (InternalErrorException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return propertiesList;
    }

    public FolderItemType getFolderItemType() {
        return FolderItemType.GCUBE_ITEM;
    }

    public long getLength() throws InternalErrorException {
        return 0L;
    }

    public String getMimeType() throws InternalErrorException {
        return null;
    }

    @Override
    public void move(WorkspaceFolder destination) throws InternalErrorException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException {
        throw new InsufficientPrivilegesException("GCUBEItem cannot be moved");
    }

    @Override
    public Node internalCopy(Node nodeFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        throw new InternalErrorException("GCUBEItem cannot be copied");
    }

    @Override
    public void internalMove(Node destinationFolderNode) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        throw new InternalErrorException("GCUBEItem cannot be moved");
    }

    public String getWorkflowId() throws InternalErrorException {
        return null;
    }

    public void setWorkflowId(String id) throws InternalErrorException {
    }

    public String getWorkflowStatus() throws InternalErrorException {
        return null;
    }

    public void setWorkflowStatus(String status) throws InternalErrorException {
    }

    public String getWorkflowData() throws InternalErrorException {
        return null;
    }

    public void setWorkflowData(String data) throws InternalErrorException {
    }

    public void removeChild(WorkspaceItem child) throws InternalErrorException, InsufficientPrivilegesException {
    }
}

