/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.repository.external;

import java.io.IOException;
import java.io.InputStream;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCUBEStorage {
    private static Logger logger = LoggerFactory.getLogger(GCUBEStorage.class);
    IClient storage = null;

    public GCUBEStorage(String portalLogin) {
        logger.trace("Calling GCUBEStorage from user: " + portalLogin);
        try {
            String currentScope = ScopeProvider.instance.get();
            String scope = Utils.getRootScope(currentScope);
            ScopeProvider.instance.set(scope);
            logger.trace("GCUBE Storage scope : " + scope);
            this.storage = new StorageClient("org.gcube.portlets.user", JCRRepository.serviceName, portalLogin, AccessType.SHARED, currentScope, false).getClient();
            Handler.activateProtocol();
        }
        catch (Exception e) {
            logger.error("GCUBE Storage initialization failed", (Throwable)e);
        }
    }

    public String putStream(InputStream is, String remotePath, String portalLogin, String mimeType) throws RemoteBackendException {
        logger.trace("GCUBE Storage - putStream - remotePath: " + remotePath);
        System.out.println("STORAGE PUT " + mimeType);
        this.storage.put(true, mimeType).LFile(is).RFile(remotePath);
        try {
            is.close();
            logger.trace("GCUBE Storage inputStream closed");
        }
        catch (IOException e) {
            logger.error("GCUBE Storage error during to close inputStream", (Throwable)e);
        }
        return this.storage.getUrl().RFile(remotePath);
    }

    public String putStream(String old_remotePath, String new_remotePath, String portalLogin, String mimeType) throws RemoteBackendException {
        logger.trace("GCUBE Storage -putStream - remotePath: " + new_remotePath);
        System.out.println("STORAGE PUT " + mimeType);
        this.storage.put(true, mimeType).LFile(old_remotePath).RFile(new_remotePath);
        return this.storage.getUrl().RFile(new_remotePath);
    }

    public long getRemoteFileSize(String remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage getRemoteFileSize - storage.getSize().RFile(" + remotePath + ")");
        long size = this.storage.getSize().RFile(remotePath);
        return size;
    }

    public void removeRemoteFile(String remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage - removeRemoteFile - remotePath: " + remotePath);
        this.storage.remove().RFile(remotePath);
    }

    public void removeRemoteFolder(String remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.removeDir().RDir(" + remotePath + ")");
        this.storage.removeDir().RDir(remotePath);
    }

    public long getRemoteFileSize(String remotePath, String portalLogin, String serviceName) throws RemoteBackendException {
        logger.trace("GCUBE Storage getRemoteFileSize - storage.getSize().RFile(" + remotePath + ")");
        return this.storage.getSize().RFile(remotePath);
    }

    public long getDiskUsageByUser(String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume used by user: " + portalLogin + "");
        return Long.parseLong(this.storage.getTotalUserVolume());
    }

    public int getTotalItemsByUser(String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get tot items of user " + portalLogin + "");
        return Integer.parseInt(this.storage.getUserTotalItems());
    }

    public long getFolderTotalVolume(String remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        return Long.parseLong(this.storage.getFolderTotalVolume().RDir(remotePath).toString());
    }

    public String getFolderLastUpdate(String remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        return this.storage.getFolderLastUpdate().RDir(remotePath);
    }

    public int getFolderTotalItems(String remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        return Integer.parseInt(this.storage.getFolderTotalItems().RDir(remotePath).toString());
    }

    public InputStream getRemoteFile(String remotePath, String portalLogin) {
        logger.trace("GCUBE Storage -getRemoteFile - stream = storage.get().RFileAsInputStream(" + remotePath + ")");
        InputStream stream = null;
        try {
            stream = this.storage.get().RFileAsInputStream(remotePath);
        }
        catch (Exception e) {
            logger.error("no payload found in Storage for remotePath: " + remotePath, (Throwable)e);
        }
        return stream;
    }

    public String getPublicLink(String remotePath, String portalLogin) {
        logger.trace("GCUBE Storage - Generate Public Link for " + remotePath);
        return this.storage.getUrl().RFile(remotePath);
    }

    public String getStorageId(String remotePath, String portalLogin) {
        logger.trace("GCUBE Storage - Generate Public Link for " + remotePath);
        MyFile file = this.storage.getMetaFile().RFile(remotePath);
        return file.getId();
    }

    public void moveRemoteFolder(String oldPath, String newPath, String portalLogin) {
        logger.trace("GCUBE Storage - storage.moveDir().from(" + oldPath + ").to(" + newPath + ")");
        try {
            this.storage.moveDir().from(oldPath).to(newPath);
        }
        catch (Exception e) {
            logger.error("GCUBE Storage - Error moving dir from " + oldPath + " to " + newPath, (Throwable)e);
        }
    }

    public void moveRemoteFile(String oldPath, String newPath, String portalLogin) {
        logger.trace("GCUBE Storage - storage.moveFile().from(" + oldPath + ").to(" + newPath + ")");
        try {
            this.storage.moveFile().from(oldPath).to(newPath);
        }
        catch (Exception e) {
            logger.error("GCUBE Storage - Error moving file from " + oldPath + " to " + newPath, (Throwable)e);
            throw new RemoteBackendException((Throwable)e);
        }
    }

    public void copyRemoteFile(String oldPath, String newPath, String portalLogin) {
        logger.trace("GCUBE Storage - storage.copyFile().from(" + oldPath + ").to(" + newPath + ")");
        this.storage.copyFile().from(oldPath).to(newPath);
    }

    public void createHardLink(String srcPath, String destPath, String portalLogin) {
        try {
            logger.trace("GCUBE Storage - storage.linkFile().from(" + srcPath + ").to(" + destPath + ")");
            this.storage.linkFile().from(srcPath).to(destPath);
        }
        catch (Exception e) {
            logger.error("GCUBE Storage error creating a linkFile", (Throwable)e);
        }
    }

    public void removeRemoteFolder(String remotePath, String portalLogin, String serviceName) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.removeDir().RDir(" + remotePath + ")");
        this.storage.removeDir().RDir(remotePath);
    }

    public String putStream(InputStream is, String new_remotePath, String portalLogin, String serviceName, String mimeType) throws RemoteBackendException {
        logger.trace("GCUBE Storage - putStream - remotePath: " + new_remotePath);
        this.storage.put(true, mimeType).LFile(is).RFile(new_remotePath);
        try {
            is.close();
            logger.trace("GCUBE Storage inputStream closed");
        }
        catch (IOException e) {
            logger.error("GCUBE Storage error during to close inputStream", (Throwable)e);
        }
        return this.storage.getUrl().RFile(new_remotePath);
    }
}

