/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.resolver;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.homelibrary.jcr.shortner.UrlEncoderUtil;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriResolverReaderParameter {
    private String baseUri = "";
    private String smpParameter = "";
    private String fileNameParameter = "";
    private String contentTypeParameter = "";
    private String query = "";
    private boolean isAvailable = false;
    public static Logger logger = LoggerFactory.getLogger(UriResolverReaderParameter.class);

    public UriResolverReaderParameter(String scope) throws Exception {
        logger.trace("UriResolverReaderParameter is istancing with scope: " + scope);
        String callerScope = ScopeProvider.instance.get();
        if (callerScope == null) {
            throw new IllegalArgumentException("scope is null");
        }
        String rootScope = Utils.getRootScope(callerScope);
        logger.debug("scope for repository creation is " + rootScope + " caller scope is " + callerScope);
        ScopeProvider.instance.set(rootScope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'HTTP-URI-Resolver'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        List endpoints = client.submit((Query)query);
        if (endpoints.size() == 0) {
            throw new Exception("No Resolver available");
        }
        String string = this.baseUri = endpoints.get(0) != null ? ((ServiceEndpoint.AccessPoint)endpoints.get(0)).address() : "";
        if (endpoints.get(0) != null) {
            this.smpParameter = ((ServiceEndpoint.AccessPoint)endpoints.get(0)).propertyMap() != null ? ((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)endpoints.get(0)).propertyMap().get("SMP_URI_parameter")).value() : "";
            this.fileNameParameter = ((ServiceEndpoint.AccessPoint)endpoints.get(0)).propertyMap() != null ? ((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)endpoints.get(0)).propertyMap().get("fileName_parameter")).value() : "";
            this.contentTypeParameter = ((ServiceEndpoint.AccessPoint)endpoints.get(0)).propertyMap() != null ? ((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)endpoints.get(0)).propertyMap().get("contentType_parameter")).value() : "";
        }
        this.isAvailable = true;
    }

    public InputStream resolveAsInputStream(String smp, String fileName, String contentType) throws Exception {
        String query = this.resolveAsUriRequest(smp, fileName, contentType, true);
        URL url = new URL(query);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("charset", "utf-8");
        connection.connect();
        return connection.getInputStream();
    }

    public String resolveAsUriRequest(String smp, String fileName, String contentType, boolean encodeParams) throws Exception {
        if (smp == null || smp.isEmpty()) {
            throw new Exception("smp url is null or empty");
        }
        if (!encodeParams) {
            this.query = this.smpParameter + "=" + smp;
            if (fileName != null && !fileName.isEmpty()) {
                this.query = this.query + "&" + this.fileNameParameter + "=" + fileName;
            }
            if (contentType != null && !contentType.isEmpty()) {
                this.query = this.query + "&" + this.contentTypeParameter + "=" + contentType;
            }
        } else {
            Map<String, String> hashParameters = this.getHashParemeters(smp, fileName, contentType);
            this.query = UrlEncoderUtil.encodeQuery(hashParameters);
        }
        String uriRequest = this.baseUri + "?" + this.query;
        logger.trace("resolve url request: " + uriRequest);
        return uriRequest;
    }

    public Map<String, String> getHashParemeters(String smp, String fileName, String contentType) throws Exception {
        HashMap<String, String> hashParameters = new HashMap<String, String>();
        if (smp == null || smp.isEmpty()) {
            throw new Exception("smp url is null or empty");
        }
        hashParameters.put(this.smpParameter, smp);
        if (fileName != null && !fileName.isEmpty()) {
            hashParameters.put(this.fileNameParameter, fileName);
        }
        if (contentType != null && !contentType.isEmpty()) {
            hashParameters.put(this.contentTypeParameter, contentType);
        }
        return hashParameters;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UriResolverReaderParameter [baseUri=");
        builder.append(this.baseUri);
        builder.append(", smpParameter=");
        builder.append(this.smpParameter);
        builder.append(", fileNameParameter=");
        builder.append(this.fileNameParameter);
        builder.append(", contentTypeParameter=");
        builder.append(this.contentTypeParameter);
        builder.append(", isAvailable=");
        builder.append(this.isAvailable);
        builder.append("]");
        return builder.toString();
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getSmpParameter() {
        return this.smpParameter;
    }

    public String getFileNameParameter() {
        return this.fileNameParameter;
    }

    public String getContentTypeParameter() {
        return this.contentTypeParameter;
    }

    public String getQuery() {
        return this.query;
    }
}

