/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;

public class JCRAccountingEntryUpdate
extends JCRAccountingEntry
implements AccountingEntryUpdate {
    private final String itemName;

    public JCRAccountingEntryUpdate(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.itemName = (String)new XStream().fromXML((String)node.getAccountingProperties().get(AccountingProperty.ITEM_NAME));
    }

    public JCRAccountingEntryUpdate(String id, String user, Calendar date, String nodeName) {
        super(id, user, date);
        this.itemName = nodeName;
        Map properties = this.entryDelegate.getAccountingProperties();
        properties.put(AccountingProperty.ITEM_NAME, new XStream().toXML((Object)this.itemName));
        this.entryDelegate.setEntryType(AccountingEntryType.UPDATE);
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.UPDATE;
    }

    @Override
    public String toString() {
        String parentValue = super.toString();
        return String.format("[%s [%s]]", parentValue, this.getEntryType());
    }

    public String getItemName() {
        return this.itemName;
    }
}

