/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRead;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryShare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUnshare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.util.MimeTypeUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFile
implements org.gcube.common.homelibrary.home.workspace.folder.items.File {
    private static Logger logger = LoggerFactory.getLogger(JCRFile.class);
    public static final String MIME_TYPE = "jcr:mimeType";
    public static final String DATA = "jcr:data";
    public static final String SIZE = "hl:size";
    public static final String REMOTE_STORAGE_PATH = "hl:remotePath";
    public static final String STORAGE_PATH = "hl:storagePath";
    String portalLogin;
    ItemDelegate itemDelegate;
    GCUBEStorage storage;

    public JCRFile(JCRWorkspace workspace, ItemDelegate itemDelegate) throws RepositoryException {
        this.itemDelegate = itemDelegate;
        this.storage = workspace.getStorage();
        this.portalLogin = workspace.getOwner().getPortalLogin();
    }

    public JCRFile(JCRWorkspace workspace, ItemDelegate itemDelegate, String mimeType, File tmpFile) throws RepositoryException, RemoteBackendException {
        this.itemDelegate = itemDelegate;
        this.storage = workspace.getStorage();
        this.portalLogin = workspace.getOwner().getPortalLogin();
        if (mimeType == null) {
            try {
                mimeType = MimeTypeUtil.getMimeType((String)itemDelegate.getTitle(), (File)tmpFile);
            }
            catch (Exception e) {
                logger.error("Error getting mimeType of " + tmpFile.getAbsolutePath());
            }
        }
        String remotePath = itemDelegate.getPath();
        String url = null;
        try {
            FileInputStream is = new FileInputStream(tmpFile);
            url = workspace.getStorage().putStream(is, remotePath, workspace.getOwner().getPortalLogin(), mimeType);
            is.close();
        }
        catch (IOException e) {
            logger.error("FileNotFoundException " + e);
        }
        HashMap<NodeProperty, String> content = new HashMap<NodeProperty, String>();
        content.put(NodeProperty.PORTAL_LOGIN, workspace.getOwner().getPortalLogin());
        content.put(NodeProperty.MIME_TYPE, mimeType);
        content.put(NodeProperty.SIZE, new XStream().toXML((Object)tmpFile.length()));
        content.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
        itemDelegate.setContent(content);
        logger.trace("GCUBEStorage URL : " + url);
    }

    public JCRFile(JCRWorkspace workspace, ItemDelegate itemDelegate, String mimeType, File tmpFile, String remotePath) throws RepositoryException, RemoteBackendException {
        this.itemDelegate = itemDelegate;
        this.storage = workspace.getStorage();
        this.portalLogin = workspace.getOwner().getPortalLogin();
        Map content = itemDelegate.getContent();
        content.put(NodeProperty.PORTAL_LOGIN, workspace.getOwner().getPortalLogin());
        content.put(NodeProperty.MIME_TYPE, mimeType);
        content.put(NodeProperty.SIZE, new XStream().toXML((Object)tmpFile.length()));
        String url = null;
        try {
            FileInputStream is = new FileInputStream(tmpFile);
            url = workspace.getStorage().putStream(is, remotePath, workspace.getOwner().getPortalLogin(), mimeType);
            content.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            is.close();
        }
        catch (IOException e) {
            logger.error(itemDelegate.getPath() + " remote path not present" + e);
        }
        logger.trace("GCUBEStorage URL : " + url);
    }

    protected GCUBEStorage getStorage() {
        return this.storage;
    }

    public String getName() throws InternalErrorException {
        return this.itemDelegate.getTitle();
    }

    public String getMimeType() {
        String mimeType = null;
        try {
            mimeType = (String)this.itemDelegate.getContent().get(NodeProperty.MIME_TYPE);
        }
        catch (Exception e) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    public InputStream getData() throws InternalErrorException {
        String remotePath = null;
        InputStream stream = null;
        try {
            try {
                remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
            }
            catch (Exception e) {
                logger.trace("Remote Path not found");
            }
            if (remotePath != null) {
                logger.trace("Retrieving streaming from Storage...");
                try {
                    stream = this.getStorage().getRemoteFile(remotePath, this.portalLogin);
                }
                catch (Exception e) {
                    logger.error("no payload for " + this.getName());
                }
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return stream;
    }

    public long getLength() throws InternalErrorException {
        long size = 0L;
        try {
            size = (Long)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.SIZE));
        }
        catch (Exception e) {
            logger.error(this.itemDelegate.getTitle() + " has not size property");
        }
        return size;
    }

    public String getPublicLink() throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
            return this.getStorage().getPublicLink(remotePath, this.portalLogin);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void getHardLink(String destPath) throws InternalErrorException {
        String remotePath = null;
        try {
            remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
            logger.trace("No public link for file: " + this.itemDelegate.getTitle());
            this.getStorage().createHardLink(remotePath, destPath, this.portalLogin);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void updateInfo(File tmpFile) throws InternalErrorException {
        String mimeType = null;
        try {
            mimeType = MimeTypeUtil.getMimeType((String)this.itemDelegate.getTitle(), (File)tmpFile);
        }
        catch (Exception e1) {
            logger.error("impossible to detect mime type of " + tmpFile.getAbsolutePath());
        }
        long size = tmpFile.length();
        String remotePath = null;
        try {
            remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
            logger.trace(this.itemDelegate.getPath() + " - mimeType: " + mimeType);
            this.setProperties(this.itemDelegate, remotePath, mimeType, size);
        }
        catch (Exception e) {
            logger.trace("No public link for file: " + this.itemDelegate.getPath());
        }
    }

    private void setProperties(ItemDelegate delegate, String remotePath, String mimeType, long size) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        delegate.getContent().put(NodeProperty.MIME_TYPE, mimeType);
        delegate.getContent().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
        delegate.getContent().put(NodeProperty.SIZE, new XStream().toXML((Object)size));
        DelegateManager manager = new DelegateManager(delegate, this.portalLogin);
        try {
            manager.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<AccountingEntry> getAccounting(ItemDelegate node) {
        ArrayList<AccountingEntry> list = new ArrayList<AccountingEntry>();
        JCRServlets servlets = null;
        try {
            servlets = JCRRepository.getServlets();
            List<AccountingDelegate> accouting = servlets.getAccountingById(node.getId());
            for (AccountingDelegate entry : accouting) {
                try {
                    switch (AccountingEntryType.getEnum((String)entry.getEntryType().toString())) {
                        case CUT: {
                            list.add(new JCRAccountingFolderEntryCut(entry));
                            break;
                        }
                        case PASTE: {
                            list.add(new JCRAccountingEntryPaste(entry));
                            break;
                        }
                        case REMOVAL: {
                            list.add(new JCRAccountingFolderEntryRemoval(entry));
                            break;
                        }
                        case RENAMING: {
                            list.add(new JCRAccountingEntryRenaming(entry));
                            break;
                        }
                        case ADD: {
                            list.add(new JCRAccountingFolderEntryAdd(entry));
                            break;
                        }
                        case UPDATE: {
                            list.add(new JCRAccountingEntryUpdate(entry));
                            break;
                        }
                        case READ: {
                            list.add(new JCRAccountingEntryRead(entry));
                            break;
                        }
                        case SHARE: {
                            list.add(new JCRAccountingEntryShare(entry));
                            break;
                        }
                        case UNSHARE: {
                            list.add(new JCRAccountingEntryUnshare(entry));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Accounting entry skipped " + entry.getEntryType().toString(), (Throwable)e);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }
}

