/**
 * 
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;
import java.util.Map;

import javax.jcr.RepositoryException;

import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRenaming;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;

import com.thoughtworks.xstream.XStream;
/**
 * @author Antonio Gioia antonio.gioia@isti.cnr.it
 *
 */
public class JCRAccountingEntryRenaming extends JCRAccountingEntry implements AccountingEntryRenaming{

	private final String oldItemName;
	
	public JCRAccountingEntryRenaming(AccountingDelegate node) throws RepositoryException {
		super(node);
		
		this.oldItemName = (String) new XStream().fromXML(node.getAccountingProperties().get(AccountingProperty.OLD_ITEM_NAME));
	}
	
	public JCRAccountingEntryRenaming(String id, String user, Calendar date, String oldItemName) {
		super(id, user, date);
		
		this.oldItemName = oldItemName;
		
		Map<AccountingProperty, String> properties = entryDelegate.getAccountingProperties();
		properties.put(AccountingProperty.OLD_ITEM_NAME, new XStream().toXML(oldItemName));
		
		entryDelegate.setEntryType(AccountingEntryType.RENAMING);
	}

	@Override
	public String getOldItemName() {
		return oldItemName;
	}
	

	@Override
	public AccountingEntryType getEntryType() {
		
		return AccountingEntryType.RENAMING;
	}
	
	@Override
	public String toString() {
		String parentValue = super.toString();
		return String.format("[%s [%s oldItemName:%s]]",parentValue, AccountingEntryType.RENAMING, oldItemName);
	}

}
