package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRProperties;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

import com.itextpdf.text.log.SysoCounter;

public abstract class JCRWorkspaceFolderItem extends JCRWorkspaceItem implements
FolderItem {

	protected static final String CONTENT			= "jcr:content";
	protected static final String FOLDER_ITEM_TYPE 	= "hl:workspaceItemType";


	public JCRWorkspaceFolderItem(JCRWorkspace workspace,
			ItemDelegate delegate)throws RepositoryException {
		super(workspace, delegate);
	}
	

	public JCRWorkspaceFolderItem(JCRWorkspace workspace, ItemDelegate delegate,
			String name, String description)  throws RepositoryException {
		super(workspace, delegate, name, description);

	}


	@Override
	public ItemDelegate save() throws RepositoryException {
		return super.save();
	}
	

	@Override
	public WorkspaceItemType getType() {
		return WorkspaceItemType.FOLDER_ITEM;
	}

	@Override
	public abstract FolderItemType getFolderItemType();

	@Override
	public abstract long getLength() throws InternalErrorException;

	@Override
	public abstract String getMimeType() throws InternalErrorException;


	@Override
	public  List<? extends WorkspaceItem> getChildren() throws InternalErrorException {
		return new ArrayList<WorkspaceItem>();
	}


	@Override
	public void removeChild(WorkspaceItem child) {
		return;
	}

	@Override
	public Properties getProperties() throws InternalErrorException {
		try {
			return new JCRProperties(delegate);
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} 
	}


	public void removeRemoteContent(Node node, WorkspaceItemType workspaceItemType) throws RepositoryException, RemoteBackendException {
		try {
			Node contentNode = node.getNode(CONTENT);
			if (contentNode.hasProperty(JCRFile.REMOTE_STORAGE_PATH)) {	

				String remotePath = contentNode.getProperty(JCRFile.REMOTE_STORAGE_PATH).getString();
				try{
					if (workspaceItemType == WorkspaceItemType.FOLDER)
						workspace.getStorage().removeRemoteFolder(remotePath, workspace.getOwner().getPortalLogin());
					else
						workspace.getStorage().removeRemoteFile(remotePath, workspace.getOwner().getPortalLogin());
					

				}catch (Exception e) {
					logger.warn(node.getName() + " payload not available", e);
				}
			}	
		} catch (PathNotFoundException e) {
			logger.error("Content node "+ CONTENT + " not found",e);
		} 
	}

	//create a new payload
	public void copyRemoteContent(ItemDelegate node) throws RepositoryException, RemoteBackendException {

		try {
			Map<NodeProperty, String> contentNode = node.getContent();
			if (contentNode.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) {	

				String remotePath = contentNode.get(NodeProperty.REMOTE_STORAGE_PATH);
				String newRemotePath = node.getPath();

				logger.debug("copy from remote path: " + remotePath + " to: "+ newRemotePath);
				
				workspace.getStorage().copyRemoteFile(remotePath, newRemotePath, workspace.getOwner().getPortalLogin());		
				contentNode.put(NodeProperty.REMOTE_STORAGE_PATH, newRemotePath);

				// Store url as byte stream in jcr:data binary property
//				ByteArrayInputStream  binaryUrl = new ByteArrayInputStream(url.getBytes());
//				Binary binary = contentNode.getSession().getValueFactory().createBinary(binaryUrl);
				contentNode.put(NodeProperty.DATA, Integer.toBinaryString(0));
				
				DelegateManager wrap = null;
				try {
					wrap = new DelegateManager(node, workspace.getOwner().getPortalLogin());
					wrap.save();
				} catch (Exception e) {
					throw new InternalErrorException(e);
				}
			}	
		} catch (Exception e) {
			logger.error("Content property "+ CONTENT + " not found",e);
		} 

	}



	public void setHardLink(ItemDelegate node, String hardLinkRemotePath) throws RepositoryException {
		logger.info("hardLinkRemotePath: " + hardLinkRemotePath);
		try {
			Map<NodeProperty, String> content = node.getContent();
			if (content.containsKey(NodeProperty.REMOTE_STORAGE_PATH)){
	
				String remotePath = content.get(NodeProperty.REMOTE_STORAGE_PATH);
				workspace.getStorage().createHardLink(remotePath, hardLinkRemotePath, workspace.getOwner().getPortalLogin());

				content.put(NodeProperty.REMOTE_STORAGE_PATH, hardLinkRemotePath);
				
				DelegateManager wrap = new DelegateManager(node, workspace.getOwner().getPortalLogin());
				wrap.save();
//				contentNode.setProperty(JCRFile.REMOTE_STORAGE_PATH, hardLinkRemotePath);

			}	
		} catch (Exception e) {
			logger.error("Content node "+ CONTENT + " not found",e);
		} 

	}



}
