/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRReportTemplate
extends JCRWorkspaceFolderItem
implements ReportTemplate {
    private final JCRFile file;

    public JCRReportTemplate(JCRWorkspace workspace, ItemDelegate itemDelegate) throws RepositoryException, InternalErrorException {
        super(workspace, itemDelegate);
        this.file = new JCRFile(workspace, itemDelegate);
    }

    public JCRReportTemplate(JCRWorkspace workspace, ItemDelegate itemDelegate, String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, int numberOfSections, String status, InputStream templateData) throws RepositoryException, RemoteBackendException, FileNotFoundException, InternalErrorException {
        super(workspace, itemDelegate, name, description);
        Validate.notNull((Object)created, (String)"Created must be not null");
        Validate.notNull((Object)lastEdit, (String)"LastEdit must be not null");
        Validate.notNull((Object)author, (String)"Author must be not null");
        Validate.notNull((Object)lastEditBy, (String)"LastEditBy must be not null");
        Validate.notNull((Object)status, (String)"Status must be not null");
        Validate.notNull((Object)templateData, (String)"TemplateData must be not null");
        File tmp = WorkspaceUtil.getTmpFile((InputStream)templateData);
        this.file = new JCRFile(workspace, itemDelegate, null, tmp);
        Map content = itemDelegate.getContent();
        content.put(NodeProperty.AUTHOR, author);
        content.put(NodeProperty.RT_CREATED, new XStream().toXML((Object)created));
        content.put(NodeProperty.LAST_EDIT, new XStream().toXML((Object)lastEdit));
        content.put(NodeProperty.LAST_EDIT_BY, lastEditBy);
        content.put(NodeProperty.NUMBER_OF_SECTION, new XStream().toXML((Object)numberOfSections));
        content.put(NodeProperty.STATUS, status);
        if (tmp != null) {
            tmp.delete();
        }
    }

    @Override
    public long getLength() throws InternalErrorException {
        return this.file.getLength();
    }

    public InputStream getData() throws InternalErrorException {
        return this.file.getData();
    }

    public Calendar getCreated() {
        Calendar created;
        try {
            created = (Calendar)new XStream().fromXML((String)this.delegate.getContent().get(NodeProperty.CREATED));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return created;
    }

    public Calendar getLastEdit() {
        Calendar lastEdit;
        try {
            lastEdit = (Calendar)new XStream().fromXML((String)this.delegate.getContent().get(NodeProperty.LAST_EDIT));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return lastEdit;
    }

    public String getAuthor() {
        String templateName = null;
        try {
            templateName = (String)this.delegate.getContent().get(NodeProperty.AUTHOR);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return templateName;
    }

    public String getLastEditBy() {
        String templateName = null;
        try {
            templateName = (String)this.delegate.getContent().get(NodeProperty.LAST_EDIT_BY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return templateName;
    }

    public int getNumberOfSections() {
        int section = 0;
        try {
            section = (Integer)new XStream().fromXML((String)this.delegate.getContent().get(NodeProperty.NUMBER_OF_SECTION));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return section;
    }

    public String getStatus() {
        String status = null;
        try {
            status = (String)this.delegate.getContent().get(NodeProperty.STATUS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return status;
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.REPORT_TEMPLATE;
    }

    @Override
    public String getMimeType() throws InternalErrorException {
        return null;
    }
}

