/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.shortner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlShortener {
    protected static final String NO_HTTP_URL_SHORTENER_AVAILABLE = "No HTTP URL Shortener available";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String LONG_URL = "longUrl";
    private static String shortnerServerUrl = "";
    protected static final String KEY = "key";
    private static String paramKeyValue = "";
    protected static Logger logger = LoggerFactory.getLogger(UrlShortener.class);
    private String uriRequest;
    private boolean isAvailable = false;

    public UrlShortener(String scope) throws Exception {
        try {
            logger.trace("Tentative reading HTTP-URL-Shortener RR");
            String callerScope = ScopeProvider.instance.get();
            String rootScope = Utils.getRootScope(callerScope);
            ScopeProvider.instance.set(rootScope);
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/text() eq 'HTTP-URL-Shortener'").setResult("$resource/Profile/AccessPoint");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
            List endpoints = client.submit((Query)query);
            if (endpoints.size() == 0) {
                this.isAvailable = false;
                logger.trace("HTTP-URL-Shortener not found");
                throw new Exception(NO_HTTP_URL_SHORTENER_AVAILABLE);
            }
            String string = shortnerServerUrl = endpoints.get(0) != null ? ((ServiceEndpoint.AccessPoint)endpoints.get(0)).address() : "";
            if (endpoints.get(0) != null) {
                paramKeyValue = ((ServiceEndpoint.AccessPoint)endpoints.get(0)).propertyMap() != null ? ((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)endpoints.get(0)).propertyMap().get(KEY)).value() : "";
            }
            String getParam = "";
            if (paramKeyValue != null && !paramKeyValue.isEmpty()) {
                getParam = "?key=" + paramKeyValue;
            }
            this.uriRequest = shortnerServerUrl + getParam;
            logger.trace("HTTP-URL-Shortener found, uriRequest: " + this.uriRequest);
            this.isAvailable = true;
        }
        catch (Exception e) {
            this.isAvailable = false;
            logger.error("an error occurred in reading RR: ", (Throwable)e);
            throw new Exception(NO_HTTP_URL_SHORTENER_AVAILABLE);
        }
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public String shorten(String longUrl) throws Exception {
        if (longUrl == null) {
            return longUrl;
        }
        try {
            logger.trace("shorten longUrl: " + longUrl);
            URL url = new URL(this.uriRequest);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", APPLICATION_JSON);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put(LONG_URL, (Object)longUrl);
            logger.trace("request json : " + jsonObj.toString());
            OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
            wr.write(jsonObj.toString());
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            JSONTokener tokener = new JSONTokener((Reader)rd);
            JSONObject jsonObject = new JSONObject(tokener);
            logger.trace("response received json : " + jsonObject.toString());
            wr.close();
            rd.close();
            return (String)jsonObject.get("id");
        }
        catch (MalformedURLException e) {
            logger.error("MalformedURLException error in UrlShortener", (Throwable)e);
            return longUrl;
        }
        catch (IOException e) {
            logger.error("IOException error in UrlShortener", (Object)e.getMessage());
            return longUrl;
        }
    }

    public static String getShortnerServerUrl() {
        return shortnerServerUrl;
    }

    public static String getKey() {
        return KEY;
    }

    public static String getParamKeyValue() {
        return paramKeyValue;
    }

    public String getUriRequest() {
        return this.uriRequest;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UrlShortener [uriRequest=");
        builder.append(this.uriRequest);
        builder.append(", isAvailable=");
        builder.append(this.isAvailable);
        builder.append("]");
        return builder.toString();
    }
}

