/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import ij.ImagePlus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.Image;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.util.WorkspaceItemUtil;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRImage
extends JCRFile
implements Image {
    private static final String noPreviewImg = "/no-thumbnail.png";
    private static final int thumb_height = 200;
    private static final int thumb_width = 281;
    protected static Logger logger = LoggerFactory.getLogger(JCRImage.class);

    public JCRImage(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRImage(JCRWorkspace workspace, ItemDelegate node, String mimeType, File tmpFile) throws RemoteBackendException, RepositoryException, IOException {
        super(workspace, node, mimeType, tmpFile);
        this.setProperties(node, tmpFile);
    }

    public JCRImage(JCRWorkspace workspace, ItemDelegate itemDelegate, String mimeType, File tmpFile, String path) throws RemoteBackendException, RepositoryException, IOException {
        super(workspace, itemDelegate, mimeType, tmpFile, path);
        this.setProperties(itemDelegate, tmpFile);
    }

    private void setProperties(ItemDelegate itemDelegate, File tmpFile) {
        int[] thumbnailSize = null;
        InputStream thumbnailStream = null;
        ImagePlus imagePlus = null;
        int width = 0;
        int height = 0;
        Map content = itemDelegate.getContent();
        try {
            imagePlus = WorkspaceItemUtil.getImgePlus(tmpFile);
            width = imagePlus.getWidth();
            height = imagePlus.getHeight();
            thumbnailSize = WorkspaceItemUtil.getThumbnailDimension(width, height);
            thumbnailStream = WorkspaceItemUtil.getThumbnailAsPng(imagePlus, thumbnailSize);
        }
        catch (Exception e) {
            thumbnailSize[0] = 281;
            thumbnailSize[1] = 200;
            thumbnailStream = JCRImage.class.getResourceAsStream(noPreviewImg);
        }
        content.put(NodeProperty.IMAGE_WIDTH, new XStream().toXML((Object)width));
        content.put(NodeProperty.IMAGE_HEIGHT, new XStream().toXML((Object)height));
        content.put(NodeProperty.THUMBNAIL_WIDTH, new XStream().toXML((Object)thumbnailSize[0]));
        content.put(NodeProperty.THUMBNAIL_HEIGHT, new XStream().toXML((Object)thumbnailSize[1]));
        try {
            if (thumbnailStream != null) {
                thumbnailStream.close();
            }
        }
        catch (IOException e) {
            logger.error("tmp file alredy closed");
        }
        if (imagePlus != null) {
            imagePlus.close();
        }
    }

    public int getWidth() {
        Integer width = (int)((Integer)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.IMAGE_WIDTH)));
        return width;
    }

    public int getHeight() {
        Integer height = (int)((Integer)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.IMAGE_HEIGHT)));
        return height;
    }

    public InputStream getThumbnail() throws InternalErrorException {
        InputStream dataImage = null;
        int[] thumbnailSize = null;
        InputStream thumbnailStream = null;
        ImagePlus imagePlus = null;
        int width = 0;
        int height = 0;
        try {
            String remotePath = (String)this.itemDelegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
            dataImage = this.getStorage().getRemoteFile(remotePath);
            imagePlus = WorkspaceItemUtil.getImgePlus(dataImage);
            width = imagePlus.getWidth();
            height = imagePlus.getHeight();
            thumbnailSize = WorkspaceItemUtil.getThumbnailDimension(width, height);
            thumbnailStream = WorkspaceItemUtil.getThumbnailAsPng(imagePlus, thumbnailSize);
        }
        catch (Exception e) {
            thumbnailStream = JCRImage.class.getResourceAsStream(noPreviewImg);
        }
        return thumbnailStream;
    }

    public int getThumbnailWidth() {
        Integer thumbWidth = (int)((Integer)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.THUMBNAIL_WIDTH)));
        return thumbWidth;
    }

    public int getThumbnailHeight() {
        Integer thumbHight = (int)((Integer)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.THUMBNAIL_HEIGHT)));
        return thumbHight;
    }

    @Override
    public void updateInfo(JCRServlets servlets, File tmp) throws InternalErrorException {
        logger.info("Udpate info in image " + this.itemDelegate.getPath());
        super.updateInfo(servlets, tmp);
        try {
            this.setProperties(this.itemDelegate, tmp);
            servlets.saveItem(this.itemDelegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

