/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.sharing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.httpclient.HttpException;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceMessage
implements WorkspaceMessage {
    private static Logger logger = LoggerFactory.getLogger(JCRWorkspaceMessage.class);
    private static final String CREATED = "jcr:created";
    private static final String SUBJECT = "hl:subject";
    private static final String BODY = "hl:body";
    private static final String ATTACHMENTS = "hl:attachments";
    private static final String ADDRESSES = "hl:addresses";
    private static final String TITLE = "jcr:title";
    private static final String OWNER = "hl:owner";
    private static final String SCOPE = "hl:scope";
    private static final String PORTAL_LOGIN = "hl:portalLogin";
    private static final String USER_ID = "hl:uuid";
    private static final String READ = "hl:read";
    private static final String OPEN = "hl:open";
    private static final String NT_USER = "nthl:user";
    private static final String NT_WORKSPACE_FOLDER_ITEM = "nthl:workspaceLeafItem";
    private final JCRWorkspace workspace;
    private final String id;
    private final String subject;
    private final String body;
    private final User user;
    private final Calendar date;
    private List<String> attachments;
    private List<String> copyAttachmentIds;
    private final List<String> addresses;
    private boolean isRead;
    private boolean isOpened;
    private final WorkspaceMessageType type;

    public JCRWorkspaceMessage(JCRWorkspace workspace, Node node, WorkspaceMessageType type) throws javax.jcr.RepositoryException {
        this.type = type;
        this.workspace = workspace;
        this.id = node.getName();
        this.subject = node.getProperty(SUBJECT).getString();
        this.body = node.getProperty(BODY).getString();
        this.isRead = node.getProperty(READ).getBoolean();
        this.isOpened = node.getProperty(OPEN).getBoolean();
        this.date = node.getProperty(CREATED).getDate();
        Node userNode = node.getNode(OWNER);
        this.user = new JCRUser(userNode.getProperty(USER_ID).getString(), userNode.getProperty(PORTAL_LOGIN).getString());
        LinkedList<String> attachments = new LinkedList<String>();
        Node attachmentsNode = node.getNode(ATTACHMENTS);
        NodeIterator iterator = attachmentsNode.getNodes();
        while (iterator.hasNext()) {
            attachments.add(iterator.nextNode().getIdentifier());
        }
        this.attachments = attachments;
        LinkedList<String> addresses = new LinkedList<String>();
        Value[] valueArray = node.getProperty(ADDRESSES).getValues();
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Value user = valueArray[n2];
            addresses.add(user.getString());
            ++n2;
        }
        this.addresses = addresses;
    }

    public JCRWorkspaceMessage(JCRWorkspace workspace, Node node, WorkspaceMessageType type, String messageId, String subject, String body, User sender, List<String> attachmentIds, List<String> addresses) throws javax.jcr.RepositoryException, InternalErrorException {
        this.type = type;
        this.workspace = workspace;
        this.id = messageId;
        this.subject = subject;
        this.body = body;
        this.user = sender;
        this.isRead = false;
        this.isOpened = false;
        this.date = Calendar.getInstance();
        this.addresses = addresses;
        this.copyAttachmentIds = new ArrayList<String>();
        node.setProperty(SUBJECT, subject);
        node.setProperty(BODY, body);
        node.setProperty(READ, false);
        node.setProperty(OPEN, false);
        Node ownerNode = node.getNode(OWNER);
        ownerNode.setProperty(USER_ID, this.user.getId());
        ownerNode.setProperty(PORTAL_LOGIN, this.user.getPortalLogin());
        node.setProperty(ADDRESSES, addresses.toArray(new String[addresses.size()]));
        Node rootAttachments = node.getNode(ATTACHMENTS);
        String rootAttachmentsId = rootAttachments.getIdentifier();
        node.getSession().save();
        Session session = node.getSession();
        LinkedList<User> users = new LinkedList<User>();
        for (String address : addresses) {
            User user = workspace.getHome().getHomeManager().getUser(address);
            if (user == null) continue;
            users.add(user);
        }
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(workspace.getOwner().getPortalLogin());
                logger.info("attachmentIds.size() " + attachmentIds.size());
                for (String attachmentId : attachmentIds) {
                    ItemDelegate nodeItem = servlets.getItemById(attachmentId);
                    JCRWorkspaceItem item = workspace.getWorkspaceItem(nodeItem);
                    if (!item.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) continue;
                    try {
                        logger.info("nodeItem.getName() " + nodeItem.getName());
                        ItemDelegate att = servlets.getItemById(rootAttachmentsId);
                        ItemDelegate newNode = item.internalCopy(servlets, servlets.getItemById(rootAttachmentsId), nodeItem.getName());
                        session.save();
                        if (this.type.equals((Object)WorkspaceMessageType.SENT)) {
                            workspace.copyRemoteContent(servlets, newNode, null);
                            servlets.saveItem(newNode);
                            logger.info("add new id to copyAttachmentIds " + newNode.getId());
                            this.copyAttachmentIds.add(newNode.getId());
                        } else if (this.type.equals((Object)WorkspaceMessageType.RECEIVED)) {
                            servlets.getItemById(rootAttachmentsId);
                            String hardLinkRemotePath = String.valueOf(node.getPath()) + "/" + nodeItem.getName();
                            workspace.setHardLink(newNode, hardLinkRemotePath);
                            session.save();
                        }
                        session.save();
                        workspace.fireItemSentEvent(item, users);
                    }
                    catch (ItemAlreadyExistException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    catch (WrongDestinationException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    catch (RepositoryException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                    catch (ItemNotFoundException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
            }
            catch (javax.jcr.RepositoryException | ItemNotFoundException | RepositoryException e) {
                throw new InternalErrorException(e);
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    public String getId() {
        return this.id;
    }

    public User getSender() {
        return this.user;
    }

    public Calendar getSendTime() {
        return this.date;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public List<String> getAttachmentsIds() {
        return this.attachments;
    }

    public List<String> getCopyAttachmentsIds() {
        return this.copyAttachmentIds;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public void open() throws InternalErrorException {
        this.isOpened = true;
        Session session = JCRRepository.getSession();
        Node root = null;
        try {
            try {
                switch (this.type) {
                    case RECEIVED: {
                        root = this.workspace.getRepository().getOwnInBoxFolder(session);
                        break;
                    }
                    case SENT: {
                        root = this.workspace.getRepository().getOutBoxFolder(session);
                    }
                }
                Node node = root.getNode(this.id);
                node.setProperty(OPEN, true);
                session.save();
            }
            catch (javax.jcr.RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public void setStatus(boolean status) throws InternalErrorException {
        this.isRead = status;
        Session session = JCRRepository.getSession();
        Node root = null;
        try {
            try {
                switch (this.type) {
                    case RECEIVED: {
                        root = this.workspace.getRepository().getOwnInBoxFolder(session);
                        break;
                    }
                    case SENT: {
                        root = this.workspace.getRepository().getOutBoxFolder(session);
                    }
                }
                Node node = root.getNode(this.id);
                node.setProperty(READ, status);
                session.save();
            }
            catch (javax.jcr.RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public void saveAttachments(String destinationFolderId) throws InternalErrorException, WrongDestinationException, ItemNotFoundException {
        JCRServlets servlets = null;
        try {
            try {
                WorkspaceFolder folder;
                ItemDelegate folderNode;
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                try {
                    folderNode = servlets.getItemById(destinationFolderId);
                    folder = (WorkspaceFolder)this.workspace.getItem(destinationFolderId);
                }
                catch (Exception e) {
                    throw new WrongDestinationException(e.getMessage());
                }
                for (String attachmentId : this.attachments) {
                    this.saveAttachment(attachmentId, folder, folderNode);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    public WorkspaceItem saveAttachment(String attachmentId, String destinationFolderId) throws InternalErrorException, WrongDestinationException, ItemNotFoundException {
        WorkspaceFolder folder;
        ItemDelegate folderNode;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                folderNode = servlets.getItemById(destinationFolderId);
                folder = (WorkspaceFolder)this.workspace.getItem(destinationFolderId);
            }
            catch (Exception e) {
                throw new WrongDestinationException(e.getMessage());
            }
        }
        finally {
            servlets.releaseSession();
        }
        return this.saveAttachment(attachmentId, folder, folderNode);
    }

    private WorkspaceItem saveAttachment(String attachmentId, WorkspaceFolder folder, ItemDelegate folderNode) throws ItemNotFoundException, WrongDestinationException, InternalErrorException {
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            ItemDelegate attachment = servlets.getItemById(attachmentId);
            String name = folder.getUniqueName(attachment.getTitle(), false);
            String pathDestination = String.valueOf(folderNode.getPath()) + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)name);
            try {
                servlets.copy(attachment.getPath(), pathDestination);
            }
            catch (HttpException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ItemDelegate itemSaved = servlets.getItemByPath(pathDestination);
            itemSaved.setOwner(this.workspace.getOwner().getPortalLogin());
            itemSaved.setTitle(name);
            this.workspace.copyRemoteContent(servlets, itemSaved, folderNode);
            servlets.saveItem(itemSaved);
            WorkspaceItem workspaceItem = this.workspace.getItem(itemSaved.getId());
            return workspaceItem;
        }
        catch (RepositoryException | RemoteBackendException e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public List<WorkspaceItem> getAttachments() throws InternalErrorException {
        LinkedList<WorkspaceItem> list = new LinkedList<WorkspaceItem>();
        Session session = JCRRepository.getSession();
        try {
            try {
                for (String id : this.attachments) {
                    list.add(this.workspace.getItem(id));
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public static enum WorkspaceMessageType {
        RECEIVED,
        SENT;

    }
}

