/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accessmanager;

import com.thoughtworks.xstream.XStream;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.accessmanager.AccessManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.AccessControlUtil;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRAccessManager
implements AccessManager {
    private Logger logger = LoggerFactory.getLogger(JCRAccessManager.class);
    public static final String JUST_OWNER = "hl:justOwner";
    public static String url;

    public JCRAccessManager() {
        url = JCRRepository.url;
    }

    public Map<String, List<String>> getACL(String absPath) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        ArrayList<AccessControlEntry> allEntries = null;
        try {
            AccessControlPolicy[] policies;
            allEntries = new ArrayList<AccessControlEntry>();
            AccessControlManager accessControlManager = session.getAccessControlManager();
            AccessControlPolicy[] accessControlPolicyArray = policies = accessControlManager.getPolicies(absPath);
            int n = policies.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlPolicy accessControlPolicy = accessControlPolicyArray[n2];
                if (accessControlPolicy instanceof AccessControlList) {
                    AccessControlEntry[] accessControlEntries;
                    AccessControlEntry[] accessControlEntryArray = accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
                    int n3 = accessControlEntries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AccessControlEntry accessControlEntry = accessControlEntryArray[n4];
                        allEntries.add(accessControlEntry);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Error getting ACL in AccessManager for node: " + absPath, (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        Map<String, List<String>> map = this.getMap(allEntries);
        return map;
    }

    public boolean modifyAce(List<String> users, String absPath, List<String> privilegesList, String order) throws InternalErrorException {
        Boolean modified;
        block17: {
            modified = true;
            try {
                this.deleteAces(absPath, users);
            }
            catch (Exception e) {
                this.logger.error("Error deleting old ACLs: " + e);
                throw new InternalErrorException((Throwable)e);
            }
            GetMethod getMethod = null;
            try {
                try {
                    HttpClient httpClient = new HttpClient();
                    StringBuilder privileges = new StringBuilder();
                    for (String privilege : privilegesList) {
                        privileges.append("&privilege@" + privilege);
                    }
                    if (order == null) {
                        order = "first";
                    }
                    for (String user : users) {
                        try {
                            String requestUrl = String.valueOf(url) + "/ModifyAceServlet?" + JCRRepository.getCredentials() + "&principalId=" + user + "&resourcePath=" + URLEncoder.encode(absPath, "UTF-8") + privileges.toString() + "&order=" + order;
                            this.logger.debug(requestUrl);
                            getMethod = new GetMethod(requestUrl);
                            httpClient.executeMethod((HttpMethod)getMethod);
                            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
                            if (getMethod == null) continue;
                            getMethod.releaseConnection();
                        }
                        catch (Exception e) {
                            this.logger.error("Error modifing ACLs: " + e);
                            throw new InternalErrorException((Throwable)e);
                        }
                    }
                    XStream xstream = new XStream();
                    try {
                        modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
                    }
                    catch (Exception e) {
                        modified = false;
                        this.logger.error("Error in Modify ace", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error in Add or Modify Permissions in AccessManager", (Throwable)e);
                    modified = false;
                    if (getMethod != null) {
                        getMethod.releaseConnection();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
                throw throwable;
            }
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    public Map<String, List<String>> getEACL(String absPath) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        ArrayList<AccessControlEntry> allEntries = null;
        try {
            AccessControlPolicy[] policies;
            allEntries = new ArrayList<AccessControlEntry>();
            AccessControlManager accessControlManager = session.getAccessControlManager();
            AccessControlPolicy[] accessControlPolicyArray = policies = accessControlManager.getEffectivePolicies(absPath);
            int n = policies.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlPolicy accessControlPolicy = accessControlPolicyArray[n2];
                if (accessControlPolicy instanceof AccessControlList) {
                    AccessControlEntry[] accessControlEntries;
                    AccessControlEntry[] accessControlEntryArray = accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
                    int n3 = accessControlEntries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AccessControlEntry accessControlEntry = accessControlEntryArray[n4];
                        allEntries.add(accessControlEntry);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Error getting Effective ACL for node: " + absPath, (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        Map<String, List<String>> map = this.getMap(allEntries);
        this.logger.debug("ACL map on " + absPath + " : " + map.toString());
        return map;
    }

    private Map<String, List<String>> getMap(List<AccessControlEntry> allEntries) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (AccessControlEntry entry : allEntries) {
            ArrayList<String> privilegesList = null;
            String key = entry.getPrincipal().getName();
            if (key.equals("everyone")) continue;
            try {
                privilegesList = (ArrayList<String>)map.get(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Privilege[] privileges = entry.getPrivileges();
            int i = 0;
            while (i < privileges.length) {
                if (privilegesList == null) {
                    privilegesList = new ArrayList<String>();
                }
                privilegesList.add(privileges[i].getName());
                ++i;
            }
            map.put(entry.getPrincipal().getName(), (List<String>)privilegesList);
        }
        return map;
    }

    public boolean setReadOnlyACL(List<String> users, String absPath) throws InternalErrorException {
        boolean flag = true;
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:read=granted");
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting WriteOwner to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean setWriteOwnerACL(List<String> users, String absPath) throws InternalErrorException {
        this.logger.debug("setAuthorAce - users: " + users.toString() + " - absPath: " + absPath);
        boolean flag = true;
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:write=granted");
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting WriteOwner to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        this.logger.debug("Ace modified");
        return flag;
    }

    public boolean setWriteAllACL(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("hl:writeAll=granted");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting Write All to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean setAccessDenied(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:read=denied");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error removing Read privilege to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean setAdminACL(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:all=granted");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting Admin to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean deleteAces(String resourcePath, List<String> users) throws InternalErrorException {
        GetMethod getMethod = null;
        Boolean modified = true;
        try {
            try {
                HttpClient httpClient = new HttpClient();
                StringBuilder applyTo = new StringBuilder();
                for (String user : users) {
                    applyTo.append("&applyTo=" + user);
                }
                String requestUrl = String.valueOf(url) + "/DeleteAcesServlet?" + JCRRepository.getCredentials() + "&absPath=" + URLEncoder.encode(resourcePath, "UTF-8") + applyTo;
                this.logger.debug(requestUrl);
                getMethod = new GetMethod(requestUrl);
                httpClient.executeMethod((HttpMethod)getMethod);
                this.logger.debug("Response " + getMethod.getResponseBodyAsString());
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
                XStream xstream = new XStream();
                modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
            }
            catch (Exception e) {
                this.logger.error("Error deleting Permissions in AccessManager", (Throwable)e);
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
                return false;
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    public Map<String, List<String>> getGrantedMap(String absPath) throws RepositoryException, InternalErrorException {
        Session session = JCRRepository.getSession();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        LinkedHashMap<Principal, JCRPrivilegesInfo.AccessRights> accessMap = new LinkedHashMap<Principal, JCRPrivilegesInfo.AccessRights>();
        AccessControlEntry[] entries = this.getDeclaredAccessControlEntries(session, absPath);
        if (entries != null) {
            AccessControlEntry[] accessControlEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlEntry ace = accessControlEntryArray[n2];
                ArrayList<String> privilegesList = null;
                Principal principal = ace.getPrincipal();
                JCRPrivilegesInfo.AccessRights accessPrivileges = (JCRPrivilegesInfo.AccessRights)accessMap.get(principal);
                if (accessPrivileges == null) {
                    accessPrivileges = new JCRPrivilegesInfo.AccessRights();
                    accessMap.put(principal, accessPrivileges);
                }
                accessPrivileges.getGranted().addAll(Arrays.asList(ace.getPrivileges()));
                Set<Privilege> deniedPrivileges = accessPrivileges.getDenied();
                for (Privilege priv : deniedPrivileges) {
                    if (privilegesList == null) {
                        privilegesList = new ArrayList<String>();
                    }
                    privilegesList.add(priv.getName());
                }
                map.put(principal.getName(), privilegesList);
                ++n2;
            }
        }
        return map;
    }

    public Map<String, List<String>> getDeniedMap(String absPath) throws RepositoryException, InternalErrorException {
        Session session = JCRRepository.getSession();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        LinkedHashMap<Principal, JCRPrivilegesInfo.AccessRights> accessMap = new LinkedHashMap<Principal, JCRPrivilegesInfo.AccessRights>();
        AccessControlEntry[] entries = this.getDeclaredAccessControlEntries(session, absPath);
        if (entries != null) {
            AccessControlEntry[] accessControlEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlEntry ace = accessControlEntryArray[n2];
                ArrayList<String> privilegesList = null;
                Principal principal = ace.getPrincipal();
                JCRPrivilegesInfo.AccessRights accessPrivileges = (JCRPrivilegesInfo.AccessRights)accessMap.get(principal);
                if (accessPrivileges == null) {
                    accessPrivileges = new JCRPrivilegesInfo.AccessRights();
                    accessMap.put(principal, accessPrivileges);
                }
                accessPrivileges.getDenied().addAll(Arrays.asList(ace.getPrivileges()));
                Set<Privilege> deniedPrivileges = accessPrivileges.getDenied();
                for (Privilege priv : deniedPrivileges) {
                    if (privilegesList == null) {
                        privilegesList = new ArrayList<String>();
                    }
                    privilegesList.add(priv.getName());
                }
                map.put(principal.getName(), privilegesList);
                ++n2;
            }
        }
        return map;
    }

    private AccessControlEntry[] getDeclaredAccessControlEntries(Session session, String absPath) throws RepositoryException {
        AccessControlPolicy[] policies;
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
        AccessControlPolicy[] accessControlPolicyArray = policies = accessControlManager.getPolicies(absPath);
        int n = policies.length;
        int n2 = 0;
        while (n2 < n) {
            AccessControlPolicy accessControlPolicy = accessControlPolicyArray[n2];
            if (accessControlPolicy instanceof AccessControlList) {
                AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
                return accessControlEntries;
            }
            ++n2;
        }
        return new AccessControlEntry[0];
    }
}

