/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.repository;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRRepository {
    public static final String PATH_SEPARATOR = "/";
    public static final String ROOT_WEBDAV = "/repository/default/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    private static final String GCUBE_FOLDER = "GCube";
    private static final String CHAT_FOLDER = "Chat";
    private static final String DOWNLOADS = "Downloads";
    private static final String SMART_FOLDER = "Folders";
    private static final String IN_BOX_FOLDER = "InBox";
    private static final String OUT_BOX_FOLDER = "OutBox";
    private static final String SERVICENAME = "HomeLibraryWebapp";
    private static final String SERVICECLASS = "DataAccess";
    private static final String VERSION = "3";
    private static final String MINOR_VERSION = "1";
    private static final String REVISION_NUMBER = "1";
    public static final String HL_VERSION = "3.1.1";
    public static final String WEBDAV_URL = "https://www.d4science.org/Home";
    private String portalLogin;
    public static Map<String, GCoreEndpoint.Profile.Endpoint> servlets;
    private static Logger logger;
    private static JCRUserManager um;

    public JCRRepository(User user) throws InternalErrorException {
        this.portalLogin = user.getPortalLogin();
        logger.debug("getHome " + this.portalLogin);
        try {
            this.init();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private static synchronized void initializeRepository() throws InternalErrorException {
        block18: {
            String context = null;
            AuthorizationEntry entry = null;
            try {
                entry = Constants.authorizationService().get(SecurityTokenProvider.instance.get());
                logger.trace("Token for caller HL" + entry.toString());
                context = entry.getContext();
                if (context == null) {
                    throw new IllegalArgumentException("context is null");
                }
                logger.debug("scope for repository creation is {} ", (Object)context);
                ScopeProvider.instance.set(context);
            }
            catch (Exception e1) {
                logger.debug("NO TOKEN");
                context = ScopeProvider.instance.get();
            }
            try {
                XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
                query.addCondition(String.format("$resource/Profile/ServiceName/text() eq '%s' and $resource/Profile/ServiceClass/text() eq '%s' ", SERVICENAME, SERVICECLASS));
                DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
                List resources = client.submit((Query)query);
                if (resources.size() == 0) {
                    throw new InternalErrorException("HomeLibraryWebapp GCoreEndpoint not in scope " + context);
                }
                if (resources.size() == 1) {
                    try {
                        GCoreEndpoint resource = (GCoreEndpoint)resources.get(0);
                        servlets = resource.profile().endpointMap();
                    }
                    catch (Throwable e) {
                        logger.error("error decrypting resource", e);
                    }
                    break block18;
                }
                if (resources.size() <= 1) break block18;
                XQuery queryhn = ICFactory.queryFor(HostingNode.class);
                queryhn.addCondition(String.format("$resource/ID/text() eq '%s'", ((GCoreEndpoint)resources.get(0)).profile().ghnId()));
                DiscoveryClient clienthn = ICFactory.clientFor(HostingNode.class);
                List hns = clienthn.submit((Query)queryhn);
                boolean isPreProd = false;
                for (HostingNode.Profile.NodeDescription.Variable res : ((HostingNode)hns.get(0)).profile().description().environmentVariables()) {
                    if (!res.key().equals("environment") || !res.value().equals("pre-poduction")) continue;
                    isPreProd = true;
                    break;
                }
                GCoreEndpoint resource = null;
                try {
                    boolean catalinaPropExist = false;
                    String catalinaPropertyfilePath = null;
                    try {
                        catalinaPropertyfilePath = JCRRepository.getCatalinaHome() + File.separator + "workspace-rep-preprod.txt";
                        Path path = Paths.get(catalinaPropertyfilePath, new String[0]);
                        catalinaPropExist = Files.exists(path, new LinkOption[0]);
                    }
                    catch (Exception e) {
                        logger.warn(catalinaPropertyfilePath + " not found");
                    }
                    boolean ghnFileExist = false;
                    String ghnPropertyfilePath = null;
                    try {
                        ghnPropertyfilePath = JCRRepository.getGHNHome() + File.separator + "workspace-rep-preprod.txt";
                        Path path1 = Paths.get(ghnPropertyfilePath, new String[0]);
                        ghnFileExist = Files.exists(path1, new LinkOption[0]);
                    }
                    catch (Exception e) {
                        logger.warn(ghnPropertyfilePath + " not found");
                    }
                    int i = 1;
                    int j = 0;
                    if (catalinaPropExist || ghnFileExist) {
                        i = 0;
                        j = 1;
                    }
                    if ((resource = isPreProd ? (GCoreEndpoint)resources.get(i) : (GCoreEndpoint)resources.get(j)) != null) {
                        servlets = resource.profile().endpointMap();
                    }
                }
                catch (Throwable e) {
                    logger.error("error decrypting resource", e);
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    private static String getCatalinaHome() {
        return System.getenv("CATALINA_HOME").endsWith(PATH_SEPARATOR) ? System.getenv("CATALINA_HOME") : System.getenv("CATALINA_HOME") + PATH_SEPARATOR;
    }

    private static String getGHNHome() {
        return System.getenv("GHN_HOME").endsWith(PATH_SEPARATOR) ? System.getenv("GHN_HOME") : System.getenv("GHN_HOME") + PATH_SEPARATOR;
    }

    public List<String> getHomeNames() throws RepositoryException {
        ArrayList<String> homes = new ArrayList<String>();
        JCRSession session = null;
        try {
            session = new JCRSession(this.portalLogin, false);
            ItemDelegate home = session.getItemByPath("/Home");
            List<ItemDelegate> children = session.getChildrenById(home.getId(), false);
            for (ItemDelegate child : children) {
                if (!child.getPrimaryType().equals("nthl:home")) continue;
                homes.add(child.getName());
            }
        }
        catch (ItemNotFoundException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            session.releaseSession();
        }
        return homes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate getHome() throws RepositoryException {
        ItemDelegate home = null;
        JCRSession session = null;
        try {
            session = new JCRSession(this.portalLogin, false);
            home = session.getItemByPath("/Home");
        }
        catch (ItemNotFoundException e) {
            try {
                home = this.getRootNode().addNode(HOME_FOLDER, "nt:folder");
                session.saveItem(home);
            }
            catch (Exception e1) {
                throw new RepositoryException(e1.getMessage());
            }
        }
        finally {
            if (session != null) {
                session.releaseSession();
            }
        }
        return home;
    }

    public static synchronized void initialize() throws InternalErrorException {
        logger.debug("Initialize repository");
        JCRRepository.initializeRepository();
    }

    public void init() throws Exception {
        String userVersion = JCRRepository.getUserVersion(this.portalLogin);
        logger.debug(this.portalLogin + " - USER VERSION: " + userVersion + " - HL VERSION: " + HL_VERSION);
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.portalLogin, false);
            ItemDelegate home = this.getHome();
            DelegateManager homeManager = new DelegateManager(home, this.portalLogin);
            ItemDelegate userHome = null;
            try {
                userHome = homeManager.addNode(this.portalLogin, "nthl:home");
                try {
                    homeManager.save(userHome);
                }
                catch (Exception e) {
                    logger.error("Impossible to create " + this.portalLogin);
                    userHome = homeManager.getNode(this.portalLogin);
                }
                um.createUser(this.portalLogin, HL_VERSION);
            }
            catch (InternalErrorException e) {
                userHome = homeManager.getNode(this.portalLogin);
            }
            DelegateManager userHomeManager = new DelegateManager(userHome, this.portalLogin);
            try {
                ItemDelegate smartFolder = userHomeManager.addNode(SMART_FOLDER, "nt:folder");
                userHomeManager.save(smartFolder);
            }
            catch (Exception e) {
                logger.debug("Folders already exists");
            }
            try {
                ItemDelegate inBoxDelegate = userHomeManager.addNode(IN_BOX_FOLDER, "nthl:rootItemSentRequest");
                userHomeManager.save(inBoxDelegate);
            }
            catch (Exception e) {
                logger.debug("InBox already exists");
            }
            try {
                ItemDelegate outBoxDelegate = userHomeManager.addNode(OUT_BOX_FOLDER, "nthl:rootItemSentRequest");
                userHomeManager.save(outBoxDelegate);
            }
            catch (Exception e) {
                logger.debug("OutBox already exists");
            }
            try {
                ItemDelegate downloadFolder = userHomeManager.addNode(DOWNLOADS, "nthl:rootFolderBulkCreator");
                userHomeManager.save(downloadFolder);
            }
            catch (Exception e) {
                logger.debug("Downloads already exists");
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
    }

    public List<String> listScopes() throws RepositoryException, InternalErrorException {
        LinkedList<String> list = new LinkedList<String>();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDelegate getGCubeRoot() throws RepositoryException, InternalErrorException {
        logger.debug("getGCubeRoot");
        JCRSession servlet = null;
        ItemDelegate gcubeRoot = null;
        try {
            servlet = new JCRSession(this.portalLogin, false);
            try {
                gcubeRoot = servlet.getItemByPath("/GCube");
            }
            catch (ItemNotFoundException e) {
                gcubeRoot = this.getRootNode().addNode(GCUBE_FOLDER, "nt:folder");
                servlet.saveItem(gcubeRoot);
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving shared root");
        }
        finally {
            servlet.releaseSession();
        }
        return gcubeRoot;
    }

    public ItemDelegate getSharedRoot() throws RepositoryException, InternalErrorException {
        logger.debug("getSharedRoot");
        JCRSession servlet = null;
        ItemDelegate sharedNode = null;
        try {
            servlet = new JCRSession(this.portalLogin, false);
            try {
                sharedNode = servlet.getItemByPath("/Share");
            }
            catch (Exception e) {
                sharedNode = this.getRootNode().addNode(SHARED_FOLDER, "nt:folder");
                servlet.saveItem(sharedNode);
            }
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving shared root");
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlet.releaseSession();
        }
        return sharedNode;
    }

    private DelegateManager getRootNode() throws RepositoryException {
        JCRSession servlet = null;
        ItemDelegate root = null;
        DelegateManager wrap = null;
        try {
            servlet = new JCRSession(this.portalLogin, false);
            root = servlet.getItemByPath(PATH_SEPARATOR);
            wrap = new DelegateManager(root, "");
        }
        catch (Exception e) {
            logger.error("Error retrieving Root Node " + e.getMessage());
            throw new RepositoryException("Error retrieving Root Node " + e.getMessage());
        }
        finally {
            servlet.releaseSession();
        }
        return wrap;
    }

    public ItemDelegate getUserHome() throws RepositoryException, ItemNotFoundException {
        logger.debug("getUserHome: /Home/" + this.portalLogin);
        ItemDelegate userHomeDelegate = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.portalLogin, false);
            userHomeDelegate = servlets.getItemByPath("/Home/" + this.portalLogin);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
        return userHomeDelegate;
    }

    public ItemDelegate getRootSmartFolders() throws RepositoryException {
        ItemDelegate smartFolders = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.portalLogin, true);
            logger.debug("getRootSmartFolders: /Home/" + this.portalLogin + PATH_SEPARATOR + SMART_FOLDER);
            try {
                smartFolders = servlets.getItemByPath("/Home/" + this.portalLogin + PATH_SEPARATOR + SMART_FOLDER);
            }
            catch (ItemNotFoundException e) {
                smartFolders = this.getUserHome(this.portalLogin).addNode(SMART_FOLDER, "nt:folder");
                servlets.saveItem(smartFolders);
            }
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
        return smartFolders;
    }

    private DelegateManager getUserHome(String user) throws InternalErrorException, RepositoryException {
        DelegateManager wrap = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.portalLogin, false);
            ItemDelegate item = servlets.getItemByPath("/Home/" + this.portalLogin);
            wrap = new DelegateManager(item, this.portalLogin);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
        return wrap;
    }

    public ItemDelegate getOwnInBoxFolder() throws javax.jcr.RepositoryException {
        ItemDelegate inBoxNode = null;
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.portalLogin, false);
            try {
                inBoxNode = servlets.getItemByPath("/Home/" + this.portalLogin + PATH_SEPARATOR + IN_BOX_FOLDER);
            }
            catch (ItemNotFoundException e) {
                inBoxNode = this.getUserHome(this.portalLogin).addNode(IN_BOX_FOLDER, "nthl:rootItemSentRequest");
                servlets.saveItem(inBoxNode);
            }
        }
        catch (Exception e) {
            throw new javax.jcr.RepositoryException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
        return inBoxNode;
    }

    public ItemDelegate getOutBoxFolder() throws javax.jcr.RepositoryException {
        ItemDelegate outBoxNode = null;
        JCRSession servlets = null;
        logger.debug("getOutBoxFolder: /Home/" + this.portalLogin + PATH_SEPARATOR + OUT_BOX_FOLDER);
        try {
            servlets = new JCRSession(this.portalLogin, false);
            try {
                outBoxNode = servlets.getItemByPath("/Home/" + this.portalLogin + PATH_SEPARATOR + OUT_BOX_FOLDER);
            }
            catch (ItemNotFoundException e) {
                outBoxNode = this.getUserHome(this.portalLogin).addNode(OUT_BOX_FOLDER, "nthl:rootItemSentRequest");
                servlets.saveItem(outBoxNode);
            }
        }
        catch (Exception e) {
            throw new javax.jcr.RepositoryException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
        return outBoxNode;
    }

    public Node getRootFolderBulkCreators(Session session) throws javax.jcr.RepositoryException {
        Node downloads = null;
        logger.debug("Get Download Folder: /Home/" + this.portalLogin + PATH_SEPARATOR + DOWNLOADS);
        if (downloads == null) {
            try {
                try {
                    downloads = session.getNode("/Home/" + this.portalLogin + PATH_SEPARATOR + DOWNLOADS);
                }
                catch (PathNotFoundException e) {
                    downloads = session.getNode("/Home/" + this.portalLogin).addNode(DOWNLOADS, "nthl:rootFolderBulkCreator");
                    session.save();
                }
            }
            catch (Exception e) {
                throw new javax.jcr.RepositoryException((Throwable)e);
            }
        }
        return downloads;
    }

    public ItemDelegate getInBoxFolder(String user) throws javax.jcr.RepositoryException, InternalErrorException {
        JCRSession servlets = null;
        ItemDelegate inBoxFolder = null;
        try {
            servlets = new JCRSession(this.portalLogin, false);
            inBoxFolder = servlets.getItemByPath("/Home/" + user + PATH_SEPARATOR + IN_BOX_FOLDER);
        }
        catch (Exception e) {
            throw new javax.jcr.RepositoryException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
        return inBoxFolder;
    }

    public String getWebDavUrl(String portalLogin) {
        return "https://www.d4science.org/Home/" + portalLogin;
    }

    public static String getUserVersion(String portalLogin) throws InternalErrorException {
        String userVersion = JCRRepository.getUserManager().getVersionByUser(portalLogin);
        return userVersion;
    }

    public ItemDelegate getChatRoot() throws RepositoryException, InternalErrorException {
        logger.debug("Get Chat root");
        JCRSession servlet = null;
        ItemDelegate sharedNode = null;
        try {
            servlet = new JCRSession(this.portalLogin, false);
            try {
                sharedNode = servlet.getItemByPath("/Chat");
            }
            catch (Exception e) {
                sharedNode = this.getRootNode().addNode(CHAT_FOLDER, "nt:folder");
                servlet.saveItem(sharedNode);
            }
        }
        catch (RepositoryException e) {
            logger.error("Error retrieving chat root");
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlet.releaseSession();
        }
        return sharedNode;
    }

    public static JCRUserManager getUserManager() {
        if (um == null) {
            um = new JCRUserManager();
        }
        return um;
    }

    static {
        logger = LoggerFactory.getLogger(JCRRepository.class);
    }
}

