/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.catalogue;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.MetadataProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.catalogue.WorkspaceCatalogue;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.search.util.SearchQueryBuilder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.lock.JCRLockManager;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRWorkspaceCatalogue
extends JCRWorkspaceFolder
implements WorkspaceCatalogue {
    public JCRWorkspaceCatalogue(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRWorkspaceCatalogue(JCRWorkspace workspace, ItemDelegate myCatalogue, String catalogueFolder, String owner) throws RepositoryException {
        super(workspace, myCatalogue, catalogueFolder, owner);
    }

    public WorkspaceItem getCatalogueItem(String id) throws InternalErrorException, InsufficientPrivilegesException {
        Validate.notNull((Object)id, (String)" ID must be not null");
        logger.debug("Get Catalogue Item by ID : " + id);
        WorkspaceItem item = null;
        try {
            item = this.workspace.getItem(id);
            if (!item.getPath().contains(this.getPath())) {
                throw new InternalErrorException(id + " is not in Catalogue");
            }
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(id + " item ID not found.");
        }
        return item;
    }

    public WorkspaceItem getCatalogueItemByPath(String path) throws InternalErrorException, InsufficientPrivilegesException {
        Validate.notNull((Object)path, (String)" path must be not null");
        logger.debug("Get Catalogue Item by path : " + path);
        WorkspaceItem item = null;
        try {
            item = this.workspace.getItemByPath(this.getPath() + path);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException(path + " path not found.");
        }
        return item;
    }

    public WorkspaceItem addWorkspaceItem(String workspaceItemID, String destinationFolderID) throws InternalErrorException {
        Validate.notNull((Object)workspaceItemID, (String)"workspaceItem Id must be not null");
        Validate.notNull((Object)destinationFolderID, (String)"destinationFolder Id must be not null");
        WorkspaceItem item = null;
        try {
            WorkspaceItem workspaceItem = this.workspace.getItem(workspaceItemID);
            WorkspaceItem destinationFolder = this.workspace.getItem(destinationFolderID);
            if (!destinationFolderID.equals(this.getId()) && !destinationFolder.getPath().contains(this.getPath())) {
                throw new InternalErrorException(destinationFolderID + " is not a catalogue folder");
            }
            String time = this.getTimestamp();
            item = workspaceItem.isFolder() ? this.copyNoSubgraph(workspaceItemID, workspaceItem.getName() + "_" + time, destinationFolderID) : this.workspace.copy(workspaceItemID, workspaceItem.getName() + "_" + time, destinationFolderID);
            item.getProperties().addProperty(MetadataProperty.WORKSPACE_ID.toString(), workspaceItemID);
        }
        catch (InsufficientPrivilegesException | ItemAlreadyExistException | ItemNotFoundException | WorkspaceFolderNotFoundException | WrongDestinationException e) {
            throw new InternalErrorException("Impossible to add workspace item with id: " + workspaceItemID + " to destination folder: " + destinationFolderID);
        }
        return item;
    }

    private String getTimestamp() {
        Date date = new Date();
        String strLong = Long.toString(date.getTime());
        return strLong;
    }

    private WorkspaceItem copyNoSubgraph(String itemId, String newName, String destinationFolderId) throws ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException, ItemAlreadyExistException, InternalErrorException {
        JCRWorkspaceItem newItem = null;
        JCRSession session = null;
        JCRLockManager lm = null;
        ItemDelegate itemDelegate = null;
        ItemDelegate destinationDelegate = null;
        try {
            session = new JCRSession(this.getOwner().getPortalLogin(), true);
            try {
                itemDelegate = session.getItemById(itemId);
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            if (destinationFolderId == null) {
                destinationFolderId = itemDelegate.getParentId();
            }
            try {
                destinationDelegate = session.getItemById(destinationFolderId);
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            if (!destinationDelegate.getPrimaryType().equals("nthl:workspaceItem") && !destinationDelegate.getPrimaryType().equals("nthl:workspaceSharedItem")) {
                throw new WrongDestinationException("Destination is not a folder");
            }
            String path = itemDelegate.getPath();
            String destinpath = destinationDelegate.getPath();
            lm = session.getLockManager();
            if (!lm.lockItem(itemId)) {
                throw new InternalErrorException("LockException: Node locked. Impossible to copy itemID " + itemId);
            }
            logger.debug("Item " + path + " has been locked");
            logger.trace("LOCK on Node id: " + path + ", " + destinpath);
            JCRWorkspaceItem item = this.workspace.getWorkspaceItem(itemDelegate);
            if (newName == null) {
                newName = item.getName();
            }
            ItemDelegate newNode = item.internalCopy(session, destinationDelegate, newName, true);
            newItem = this.workspace.getWorkspaceItem(newNode);
            Calendar now = Calendar.getInstance();
            JCRAccountingEntryPaste entryPaste = new JCRAccountingEntryPaste(newItem.getId(), this.getOwner().getPortalLogin(), now, destinationDelegate.getTitle());
            entryPaste.save(session);
            if (destinationDelegate != null) {
                logger.debug("Set ADD accounting entry to destination folder " + destinationDelegate.getPath());
                JCRAccountingFolderEntryAdd entryAdd = new JCRAccountingFolderEntryAdd(destinationFolderId, this.getOwner().getPortalLogin(), now, newItem.getType(), newItem.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)newItem).getFolderItemType() : null, newItem.getName(), newItem.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)newItem).getMimeType() : null);
                entryAdd.save(session);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (lm != null) {
                lm.unlockItem(itemId);
            }
            logger.trace("Release LOCK on Node ids : " + itemId + ", " + destinationFolderId);
            session.releaseSession();
        }
        return newItem;
    }

    public WorkspaceItem getWorkspaceItemByCatalogueID(String catalogueItemID) throws InternalErrorException {
        Validate.notNull((Object)catalogueItemID, (String)"Catalogue ID must be not null");
        WorkspaceItem item = null;
        try {
            WorkspaceItem workspaceItem = this.workspace.getItem(catalogueItemID);
            String originalID = workspaceItem.getProperties().getPropertyValue(MetadataProperty.WORKSPACE_ID.toString());
            item = this.workspace.getItem(originalID);
        }
        catch (Exception e) {
            throw new InternalErrorException("Workspace Item not found by catalogue ID " + catalogueItemID);
        }
        return item;
    }

    public List<WorkspaceItem> getCatalogueItemByWorkspaceID(String workspaceItemID) throws InternalErrorException {
        Validate.notNull((Object)workspaceItemID, (String)"Workspace ID must be not null");
        List<WorkspaceItem> items = null;
        try {
            SearchQueryBuilder query = new SearchQueryBuilder();
            query.contains(MetadataProperty.WORKSPACE_ID.toString(), workspaceItemID);
            items = this.workspace.searchByProperties(query.build());
        }
        catch (Exception e) {
            throw new InternalErrorException("Catalogue Items not found by Workspace ID " + workspaceItemID);
        }
        return items;
    }

    public WorkspaceItem addWorkspaceItem(String workspaceItemID) throws InternalErrorException {
        return this.addWorkspaceItem(workspaceItemID, this.getId());
    }
}

