/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.trash;

import com.thoughtworks.xstream.XStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRestore;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.util.TokenUtility;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRWorkspaceTrashItem
extends JCRWorkspaceFolder
implements WorkspaceTrashItem {
    public JCRWorkspaceTrashItem(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRWorkspaceTrashItem(JCRWorkspace workspace, ItemDelegate delegate, String name, String description, Calendar date, String portalLogin, String originalParentId, String mimeType, long length, boolean isFolder, String originalPath) throws RepositoryException {
        super(workspace, delegate, name, description);
        delegate.setProperties(new HashMap());
        delegate.getProperties().put(NodeProperty.TRASH_ITEM_NAME, name);
        delegate.getProperties().put(NodeProperty.DELETE_DATE, new XStream().toXML((Object)Calendar.getInstance()));
        delegate.getProperties().put(NodeProperty.DELETE_BY, portalLogin);
        delegate.getProperties().put(NodeProperty.ORIGINAL_PARENT_ID, originalParentId);
        delegate.getProperties().put(NodeProperty.DELETED_FROM, originalPath);
        delegate.getProperties().put(NodeProperty.TRASH_ITEM_MIME_TYPE, mimeType);
        delegate.getProperties().put(NodeProperty.LENGTH, new XStream().toXML((Object)length));
        delegate.getProperties().put(NodeProperty.IS_FOLDER, new XStream().toXML((Object)isFolder));
    }

    public void restore() throws InternalErrorException {
        ItemDelegate itemToRestore = null;
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
                DelegateManager wrap = new DelegateManager(this.delegate, this.workspace.getOwner().getPortalLogin());
                itemToRestore = wrap.getNode(this.getName());
                ItemDelegate originalParentNode = null;
                try {
                    originalParentNode = servlets.getItemById(this.getOriginalParentId());
                    logger.debug("Original Parent Item path: " + originalParentNode.getPath());
                }
                catch (Exception e) {
                    logger.warn("The original Parent Node does not exist anymore, the item will be restored to the root");
                }
                ItemDelegate parentNode = null;
                if (originalParentNode != null) {
                    boolean inTrash = this.workspace.isInTrash(originalParentNode);
                    logger.debug(String.valueOf(originalParentNode.getPath()) + " is In Trash? " + inTrash);
                    if (inTrash) {
                        parentNode = servlets.getItemById(this.workspace.getRoot().getId());
                        logger.debug("The file " + this.getName() + " will be restored in the root");
                    } else {
                        parentNode = originalParentNode;
                        logger.debug("The file " + this.getName() + " will be restored to the original parent");
                    }
                } else {
                    parentNode = servlets.getItemById(this.workspace.getRoot().getId());
                }
                if (this.workspace.exists(this.getName(), parentNode.getId())) {
                    logger.debug(String.valueOf(this.getName()) + " already exists in " + parentNode.getPath());
                    try {
                        String time = JCRWorkspaceTrashItem.timeStampRename();
                        this.setName(itemToRestore, String.valueOf(time) + this.getName());
                    }
                    catch (Exception e1) {
                        throw new InternalErrorException((Throwable)e1);
                    }
                }
                this.workspace.moveItem(itemToRestore.getId(), parentNode.getId());
                ItemDelegate folderToRemove = servlets.getItemById(this.delegate.getId());
                logger.debug("Remove folder: " + folderToRemove.getPath());
                DelegateManager wrap1 = new DelegateManager(folderToRemove, this.workspace.getOwner().getPortalLogin());
                wrap1.remove();
                try {
                    JCRAccountingFolderEntryRemoval entryDelete = new JCRAccountingFolderEntryRemoval(itemToRestore.getId(), this.workspace.getOwner().getPortalLogin(), this.getDeletedTime(), this.workspace.getWorkspaceItem(itemToRestore).getType(), this.workspace.getFolderItemType(itemToRestore), this.getName(), this.getMimeType());
                    entryDelete.save(servlets);
                    JCRAccountingEntryRestore entryRestore = new JCRAccountingEntryRestore(itemToRestore.getId(), this.workspace.getOwner().getPortalLogin(), Calendar.getInstance(), this.getName());
                    entryRestore.save(servlets);
                }
                catch (Exception e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (WrongDestinationException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (InsufficientPrivilegesException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemAlreadyExistException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (WorkspaceFolderNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (WrongItemTypeException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    private static String timeStampRename() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HHmmssss_");
        String formattedDate = sdf.format(date);
        return formattedDate;
    }

    public void deletePermanently() throws InternalErrorException {
        logger.trace("Calling Delete From Trash Servlet");
        GetMethod getMethod = null;
        try {
            try {
                HttpClient httpClient = new HttpClient();
                getMethod = new GetMethod(String.valueOf(JCRRepository.servlets.get("DeleteFromTrash").uri().toString()) + "?" + "id" + "=" + this.getId() + "&" + "login" + "=" + this.workspace.getOwner().getPortalLogin());
                TokenUtility.setHeader(getMethod);
                int response = httpClient.executeMethod((HttpMethod)getMethod);
                if (response != 200) {
                    throw new HttpException("Received error status " + response);
                }
            }
            catch (Exception e) {
                logger.error("Error deleting item from trash ID " + this.getId(), (Throwable)e);
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.TRASH_ITEM;
    }

    public long getLength() throws InternalErrorException {
        return (Long)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.LENGTH));
    }

    public String getMimeType() throws InternalErrorException {
        return (String)this.delegate.getProperties().get(NodeProperty.TRASH_ITEM_MIME_TYPE);
    }

    public String getDeletedFrom() {
        return (String)this.delegate.getProperties().get(NodeProperty.DELETED_FROM);
    }

    public String getOriginalParentId() {
        return (String)this.delegate.getProperties().get(NodeProperty.ORIGINAL_PARENT_ID);
    }

    public Calendar getDeletedTime() {
        return (Calendar)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.DELETE_DATE));
    }

    public String getDeletedBy() {
        return (String)this.delegate.getProperties().get(NodeProperty.DELETE_BY);
    }

    @Override
    public boolean isFolder() {
        return (Boolean)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.IS_FOLDER));
    }

    @Override
    public String getName() throws InternalErrorException {
        return (String)this.delegate.getProperties().get(NodeProperty.TRASH_ITEM_NAME);
    }

    public void setName(ItemDelegate node, String name) throws RepositoryException {
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), true);
                ItemDelegate parent = servlets.getItemById(node.getParentId());
                String newPath = String.valueOf(parent.getPath()) + this.workspace.getPathSeparator() + name;
                node.setTitle(name);
                servlets.saveItem(node);
                servlets.move(node.getPath(), newPath);
            }
            catch (RepositoryException e) {
                throw new RepositoryException(e.getMessage());
            }
            catch (Exception e) {
                logger.error("Error setting a new name to WorkspaceTrashItem: " + e);
                servlets.releaseSession();
            }
        }
        finally {
            servlets.releaseSession();
        }
    }
}

