/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.versioning.WorkspaceVersion;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRPDFFile;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.util.MetaInfo;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRExternalFile
extends JCRWorkspaceFolderItem
implements ExternalFile {
    protected JCRFile file;
    protected ItemDelegate itemDelegate;

    public JCRExternalFile(JCRWorkspace workspace, ItemDelegate itemDelegate) throws RepositoryException, InternalErrorException {
        this(workspace, itemDelegate, ContentType.GENERAL);
        this.itemDelegate = itemDelegate;
    }

    public JCRExternalFile(JCRWorkspace workspace, ItemDelegate itemDelegate, String name, String description, MetaInfo info, Map<String, String> properties) throws RepositoryException, IOException, RemoteBackendException {
        this(workspace, itemDelegate, name, description, ContentType.GENERAL, info, properties);
        this.itemDelegate = itemDelegate;
    }

    public JCRExternalFile(JCRWorkspace workspace, ItemDelegate itemDelegate, ContentType contentType) throws RemoteBackendException, InternalErrorException, RepositoryException {
        super(workspace, itemDelegate);
        this.itemDelegate = itemDelegate;
        switch (contentType) {
            case GENERAL: {
                this.file = new JCRFile(workspace, itemDelegate);
                break;
            }
            case IMAGE: {
                this.file = new JCRImage(workspace, itemDelegate);
                break;
            }
            case PDF: {
                this.file = new JCRPDFFile(workspace, itemDelegate);
                break;
            }
            default: {
                this.file = null;
            }
        }
    }

    protected JCRExternalFile(JCRWorkspace workspace, ItemDelegate delegate, String name, String description, ContentType contentType, MetaInfo info, Map<String, String> properties) throws RepositoryException, IOException, RemoteBackendException {
        super(workspace, delegate, name, description, properties);
        this.itemDelegate = delegate;
        try {
            this.createFile(workspace, delegate, name, description, info, contentType);
        }
        catch (Exception e) {
            logger.error("Error creating JCRExternalFile from " + delegate.getPath());
        }
    }

    private void createFile(JCRWorkspace workspace, ItemDelegate delegate, String name, String description, MetaInfo info, ContentType contentType) throws InternalErrorException {
        this.itemDelegate = delegate;
        switch (contentType) {
            case GENERAL: {
                delegate.setContent(new HashMap());
                delegate.getContent().put(NodeProperty.CONTENT, ContentType.GENERAL.toString());
                delegate.getContent().put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_FILE.toString());
                try {
                    this.file = new JCRFile(workspace, delegate, info);
                    break;
                }
                catch (RemoteBackendException e) {
                    throw new InternalErrorException(e.getMessage());
                }
            }
            case IMAGE: {
                delegate.setContent(new HashMap());
                delegate.getContent().put(NodeProperty.CONTENT, ContentType.IMAGE.toString());
                delegate.getContent().put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_IMAGE.toString());
                try {
                    this.file = new JCRImage(workspace, delegate, info);
                    break;
                }
                catch (RemoteBackendException e) {
                    throw new InternalErrorException(e.getMessage());
                }
            }
            case PDF: {
                delegate.setContent(new HashMap());
                delegate.getContent().put(NodeProperty.CONTENT, ContentType.PDF.toString());
                delegate.getContent().put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_PDF_FILE.toString());
                try {
                    this.file = new JCRPDFFile(workspace, delegate, info);
                    break;
                }
                catch (RemoteBackendException e) {
                    throw new InternalErrorException(e.getMessage());
                }
            }
            default: {
                this.file = null;
            }
        }
    }

    public String getStorageId() throws InternalErrorException {
        return this.file.getStorageId();
    }

    @Override
    public void setStorageId(String storageID) throws InternalErrorException {
        this.file.setStorageId(storageID);
    }

    @Override
    public String getMimeType() {
        return this.file.getMimeType();
    }

    public InputStream getData() throws InternalErrorException {
        return this.file.getData();
    }

    @Override
    public long getLength() throws InternalErrorException {
        return this.file.getLength();
    }

    @Override
    public FolderItemType getFolderItemType() {
        return FolderItemType.EXTERNAL_FILE;
    }

    public void setData(InputStream data) throws InternalErrorException {
        Validate.notNull((Object)data, (String)"Data must be not null");
        JCRSession servlets = null;
        try {
            try {
                servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
                ItemDelegate delegate = servlets.getItemById(this.getId());
                FolderItemType type = FolderItemType.valueOf((String)((String)delegate.getProperties().get(NodeProperty.FOLDER_ITEM_TYPE)));
                switch (type) {
                    case EXTERNAL_FILE: {
                        this.file = new JCRFile(this.workspace, delegate, data);
                        break;
                    }
                    case EXTERNAL_IMAGE: {
                        this.file = new JCRImage(this.workspace, delegate, data);
                        break;
                    }
                    case EXTERNAL_PDF_FILE: {
                        this.file = new JCRPDFFile(this.workspace, delegate, data);
                        break;
                    }
                    default: {
                        throw new InternalErrorException("Item type wrong" + type);
                    }
                }
            }
            catch (Exception e) {
                throw new InternalErrorException("Content appears to be not valid: " + e.getMessage());
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    public String getPublicLink() throws InternalErrorException {
        return this.file.getPublicLink();
    }

    public void getHardLink(String linkName) throws InternalErrorException {
        this.file.getHardLink(linkName);
    }

    public void updateInfo(JCRSession servlets, MetaInfo info) throws InternalErrorException {
        this.file.updateInfo(servlets, info);
    }

    public WorkspaceVersion getCurrentVersion() throws InternalErrorException {
        return this.workspace.getVersioning().getCurrentVersion(this.getId());
    }

    public List<WorkspaceVersion> getVersionHistory() throws InternalErrorException {
        return this.workspace.getVersioning().getVersionHistory(this.getId());
    }

    public void restoreVersion(String versionID) throws InternalErrorException, InsufficientPrivilegesException {
        Validate.notNull((Object)versionID, (String)"Version must be not null");
        if (!JCRPrivilegesInfo.canModifyProperties(this.getOwner().getPortalLogin(), this.workspace.getOwner().getPortalLogin(), this.getId(), false)) {
            throw new InsufficientPrivilegesException("Insufficient privileges to restore version " + versionID);
        }
        this.workspace.getVersioning().restoreVersion(this.getId(), this.getRemotePath(), versionID);
    }

    public void removeVersion(String versionID) throws InternalErrorException, InsufficientPrivilegesException {
        Validate.notNull((Object)versionID, (String)"Version must be not null");
        WorkspaceVersion version = this.workspace.getVersioning().getVersion(this.getId(), versionID);
        String versionOwner = version.getUser();
        logger.info("Owner of version " + versionID + " is " + versionOwner);
        if (this.isShared() && !this.canRemoveVersion(versionOwner)) {
            throw new InsufficientPrivilegesException("Insufficient privileges to delete version " + versionID);
        }
        this.workspace.getVersioning().removeVersion(this.getId(), this.getRemotePath(), versionID);
    }

    private boolean canRemoveVersion(String owner) throws InternalErrorException {
        boolean canDo = false;
        ACLType privilege = JCRPrivilegesInfo.getACLByUser(this.workspace.getOwner().getPortalLogin(), this.getAbsolutePath());
        switch (privilege) {
            case WRITE_ALL: 
            case ADMINISTRATOR: {
                canDo = true;
                break;
            }
            case WRITE_OWNER: {
                if (!this.workspace.getOwner().getPortalLogin().equals(owner)) break;
                canDo = true;
                break;
            }
        }
        logger.info("Can " + this.workspace.getOwner().getPortalLogin() + " do operation on versions of  " + this.getAbsolutePath() + "? " + canDo);
        return canDo;
    }

    public void removeVersions(List<String> versions) throws InternalErrorException, InsufficientPrivilegesException {
        for (String version : versions) {
            this.removeVersion(version);
        }
    }

    public InputStream downloadVersion(String versionID) throws InternalErrorException {
        Validate.notNull((Object)versionID, (String)"Version must be not null");
        try {
            String remotePath = this.workspace.getVersioning().getVersion(this.getId(), versionID).getRemotePath();
            return this.workspace.getStorage().getRemoteFile(remotePath);
        }
        catch (Exception e) {
            throw new InternalErrorException("Cannot download file ID " + this.getId() + " version " + versionID + " - " + e.getMessage());
        }
    }

    public WorkspaceVersion getVersion(String versionID) throws InternalErrorException {
        Validate.notNull((Object)versionID, (String)"Version must be not null");
        try {
            return this.workspace.getVersioning().getVersion(this.getId(), versionID);
        }
        catch (Exception e) {
            throw new InternalErrorException("Cannot get version " + versionID + " of item ID " + this.getId() + " - " + e.getMessage());
        }
    }
}

