package org.gcube.common.homelibrary.jcr.sharing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;

import org.apache.commons.httpclient.HttpException;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.thoughtworks.xstream.XStream;

public class JCRWorkspaceMessage implements WorkspaceMessage {

	private static Logger logger = LoggerFactory.getLogger(JCRWorkspaceMessage.class);

	public enum WorkspaceMessageType {
		RECEIVED,
		SENT
	};



	private static final String NT_WORKSPACE_FOLDER_ITEM			= "nthl:workspaceLeafItem";

	private final JCRWorkspace workspace;
	private final ItemDelegate messageItem;
	private final WorkspaceMessageType type;
	private List<String> copyAttachmentIds;
	private boolean isRead;
	private boolean isOpened;

	//	private final String id;
	//	private final String subject;
	//	private final String body;
	//	private final User user;
	//	private final Calendar date;
	//	private List<String> attachments;
	//	private final List<String> addresses;
	//	private boolean isRead;
	//	private boolean isOpened;

	public JCRWorkspaceMessage(JCRWorkspace workspace, ItemDelegate messageItem, WorkspaceMessageType type) throws RepositoryException {

		super();

		this.workspace = workspace;
		this.messageItem = messageItem;
		this.type = type;

		//		this.id = node.getName();
		//
		//
		//		this.subject = node.getProperty(SUBJECT).getString();
		//		this.body = node.getProperty(BODY).getString();
		//		this.isRead = node.getProperty(READ).getBoolean();
		//		this.isOpened = node.getProperty(OPEN).getBoolean();
		//
		//		this.date = node.getProperty(CREATED).getDate();
		//		Node userNode = node.getNode(OWNER);
		//		this.user = new JCRUser(userNode.getProperty(USER_ID).getString(),
		//				userNode.getProperty(PORTAL_LOGIN).getString()/*,
		//				GCUBEScope.getScope(userNode.getProperty(SCOPE).getString())*/);
		//
		//
		//		List<String> attachments = new LinkedList<String>();
		//		Node attachmentsNode = node.getNode(ATTACHMENTS);
		//		for(NodeIterator iterator = attachmentsNode.getNodes(); iterator.hasNext();) {
		//			attachments.add(iterator.nextNode().getIdentifier());
		//		}
		//
		//		this.attachments = attachments;
		//
		//		List<String> addresses = new LinkedList<String>();
		//		for(Value user : node.getProperty(ADDRESSES).getValues()) {
		//			addresses.add(user.getString());
		//		}
		//
		//		this.addresses = addresses;this.user = new JCRUser(userNode.getProperty(USER_ID).getString(),
		//		userNode.getProperty(PORTAL_LOGIN).getString()/*,
		//		G

	}



	public JCRWorkspaceMessage(JCRWorkspace workspace, ItemDelegate messageItem, WorkspaceMessageType type, String messageId, String subject, String body,
			User sender, List<String> attachmentIds, List<String> addresses) throws  RepositoryException,
			InternalErrorException {

		this.workspace = workspace;
		this.messageItem = messageItem;
		this.type = type;
		this.copyAttachmentIds = new ArrayList<String>();
		this.isRead = false;
		this.isOpened = false;
		//		this.date = Calendar.getInstance();


		Map<NodeProperty, String> content = new HashMap<NodeProperty, String>();
		content.put(NodeProperty.SUBJECT, subject);
		content.put(NodeProperty.BODY, body);
		content.put(NodeProperty.READ, new XStream().toXML(false));
		content.put(NodeProperty.OPEN, new XStream().toXML(false));
		//		content.put(NodeProperty.USER_ID, messageItem.getOwner());
		content.put(NodeProperty.PORTAL_LOGIN, sender.getPortalLogin());
		content.put(NodeProperty.ADDRESSES, new XStream().toXML(addresses.toArray(new String[addresses.size()])));
		content.put(NodeProperty.ATTACHMENTS_ID, new XStream().toXML(attachmentIds));


		messageItem.setContent(content);

		//		node.setProperty(SUBJECT, subject);
		//		node.setProperty(BODY, body);
		//		node.setProperty(READ, false);
		//		node.setProperty(OPEN, false);
		//
		//		Node ownerNode =  node.getNode(OWNER);
		//		ownerNode.setProperty(USER_ID,user.getId());
		//		//ownerNode.setProperty(SCOPE, user.getScope().toString());
		//		ownerNode.setProperty(PORTAL_LOGIN, user.getPortalLogin());
		//
		//		node.setProperty(ADDRESSES, addresses.toArray(new String[addresses.size()]));

		//**HERE

		JCRServlets servlets = null;
		ItemDelegate saved;
		String rootAttachmentsId = null;
		try{
			servlets = new JCRServlets(workspace.getOwner().getPortalLogin());
			saved = servlets.saveItem(messageItem);
			DelegateManager dm = new DelegateManager(saved, workspace.getOwner().getPortalLogin());
			rootAttachmentsId = dm.getNode(NodeProperty.ATTACHMENTS_ID.toString()).getId();
		} catch (org.gcube.common.homelibrary.model.exceptions.RepositoryException | ItemNotFoundException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		//		Node rootAttachments = node.getNode(NodeProperty.ATTACHMENTS_ID);
		//
		//		String rootAttachmentsId = rootAttachments.getIdentifier();
		//
		//		node.getSession().save();



		//		Session session = node.getSession();

		List<User> users = new LinkedList<User>();
		for (String address : addresses) {
			User user = workspace.getHome().getHomeManager().getUser(address);
			if(user != null)
				users.add(user);
		}

		//		JCRServlets servlets = null;
		try{

			//			servlets = new JCRServlets(workspace.getOwner().getPortalLogin());
			logger.info("attachmentIds.size() " + attachmentIds.size());
			for(String attachmentId : attachmentIds) {
				ItemDelegate nodeItem = servlets.getItemById(attachmentId);

				WorkspaceItem item = workspace.getWorkspaceItem(nodeItem);			
				if(item.getType().equals(WorkspaceItemType.FOLDER_ITEM)){
					try {
						logger.info("nodeItem.getName() " + nodeItem.getName());

						ItemDelegate att = servlets.getItemById(rootAttachmentsId);

						ItemDelegate newNode = ((JCRWorkspaceItem)item).internalCopy(servlets, servlets.getItemById(rootAttachmentsId), nodeItem.getName());

						if (this.type.equals(WorkspaceMessageType.SENT)){			
							//copy all remote content item child nodes.
							workspace.copyRemoteContent(servlets, newNode, null);

							servlets.saveItem(newNode);

							logger.info("add new id to copyAttachmentIds " + newNode.getId());
							copyAttachmentIds.add(newNode.getId());

						} else if (this.type.equals(WorkspaceMessageType.RECEIVED)){
							servlets.getItemById(rootAttachmentsId);
							//create hardlink

							String hardLinkRemotePath = messageItem.getPath() + "/"+ nodeItem.getName();	
							//						logger.info("WorkspaceMessageType.RECEIVED, messageId: " + messageId);
							workspace.setHardLink(newNode, hardLinkRemotePath);
						}


						workspace.fireItemSentEvent(item, users);	

					} catch (ItemAlreadyExistException e) {
						throw new InternalErrorException(e);
					} catch (WrongDestinationException e) {
						throw new InternalErrorException(e);
					} catch (org.gcube.common.homelibrary.model.exceptions.RepositoryException e) {
						throw new InternalErrorException(e);
					} catch (ItemNotFoundException e) {
						throw new InternalErrorException(e);
					}
				}
			}

		} catch (org.gcube.common.homelibrary.model.exceptions.RepositoryException | ItemNotFoundException e) {
			throw new InternalErrorException(e);

		}finally{
			servlets.releaseSession();
		}
	}


	@Override
	public String getId() {
		return messageItem.getName();
	}

	@Override
	public User getSender() {
		return new JCRUser(messageItem.getOwner(),messageItem.getOwner());

	}

	@Override
	public Calendar getSendTime() {
		return messageItem.getCreationTime();
	}

	@Override
	public String getSubject() {
		return messageItem.getProperties().get(NodeProperty.SUBJECT);
	}

	@Override
	public String getBody() {
		return messageItem.getProperties().get(NodeProperty.BODY);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<String> getAttachmentsIds() {
		return (List<String>) new XStream().fromXML(messageItem.getProperties().get(NodeProperty.ATTACHMENTS));
	}

	@Override
	public List<String> getCopyAttachmentsIds() {
		return copyAttachmentIds;
	}

	@Override
	public boolean isRead() {
		return (boolean) new XStream().fromXML(messageItem.getProperties().get(NodeProperty.READ));
	}

	@Override
	public void open() throws InternalErrorException {

		this.isOpened = true;

		JCRServlets servlets = null;
		ItemDelegate root = null;
		try {
			servlets = new JCRServlets(workspace.getOwner().getPortalLogin());
			switch (type) {
			case RECEIVED:
				root = workspace.getRepository().getOwnInBoxFolder();
				break;
			case SENT:
				root = workspace.getRepository().getOutBoxFolder();
				break;
			}

			DelegateManager manager = new DelegateManager(root, workspace.getOwner().getPortalLogin());
			ItemDelegate node = manager.getNode(getId());
			node.getProperties().put(NodeProperty.OPEN, new XStream().toXML(true));
			//			node.setOpen(true);
			servlets.saveItem(node);
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (ItemNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (org.gcube.common.homelibrary.model.exceptions.RepositoryException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			if (servlets!=null)
				servlets.releaseSession();
		}
	}

	@Override
	public void setStatus(boolean status) throws InternalErrorException {
		this.isRead = status;

		JCRServlets servlets = null;
		ItemDelegate root = null;
		try {
			servlets = new JCRServlets(workspace.getOwner().getPortalLogin());
			switch (type) {
			case RECEIVED:
				root = workspace.getRepository().getOwnInBoxFolder();
				break;
			case SENT:
				root = workspace.getRepository().getOutBoxFolder();
				break;
			}

			DelegateManager manager = new DelegateManager(root, workspace.getOwner().getPortalLogin());
			ItemDelegate node = manager.getNode(getId());
			node.getProperties().put(NodeProperty.READ, new XStream().toXML(status));
			servlets.saveItem(node);
			//			Node node = root.getNode(getId());
			//			node.setProperty(NodeProperty.READ, status);
			//			session.save();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (ItemNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (org.gcube.common.homelibrary.model.exceptions.RepositoryException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			if (servlets!=null)
				servlets.releaseSession();
		}

	}

	@Override
	public void saveAttachments(String destinationFolderId) throws InternalErrorException, 
	WrongDestinationException, ItemNotFoundException {

		JCRServlets servlets = null;
		try{
			servlets = new JCRServlets(workspace.getOwner().getPortalLogin());

			ItemDelegate folderNode;
			WorkspaceFolder folder;
			try {
				folderNode = servlets.getItemById(destinationFolderId);
				folder = (WorkspaceFolder)workspace.getItem(destinationFolderId);
			} catch (Exception e) {
				throw new WrongDestinationException(e.getMessage());
			}
			@SuppressWarnings("unchecked")
			List<String> attachs = (List<String>) new XStream().fromXML(messageItem.getProperties().get(NodeProperty.ATTACHMENTS));
			for(String attachmentId : attachs) {
				saveAttachment(attachmentId, folder, folderNode);
			}		
		} catch (org.gcube.common.homelibrary.model.exceptions.RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			servlets.releaseSession();
		}

	}

	@Override
	public WorkspaceItem saveAttachment(String attachmentId, String destinationFolderId) throws InternalErrorException, 
	WrongDestinationException, ItemNotFoundException {

		ItemDelegate folderNode; 
		WorkspaceFolder folder;
		JCRServlets servlets = null;
		try{
			servlets = new JCRServlets(workspace.getOwner().getPortalLogin());
			folderNode =  servlets.getItemById(destinationFolderId);	
			folder = (WorkspaceFolder)workspace.getItem(destinationFolderId);
		} catch (Exception e) {
			throw new WrongDestinationException(e.getMessage());
		} finally {
			servlets.releaseSession();
		}
		return saveAttachment(attachmentId, folder, folderNode);
	}

	private WorkspaceItem saveAttachment(String attachmentId,
			WorkspaceFolder folder, ItemDelegate folderNode) throws ItemNotFoundException,
			WrongDestinationException, InternalErrorException {

		JCRServlets servlets = null;
		try{
			servlets = new JCRServlets(workspace.getOwner().getPortalLogin());
			ItemDelegate attachment = servlets.getItemById(attachmentId);
			// TODO should implement a new method getUniqueName without open a new session
			String name = folder.getUniqueName(attachment.getTitle(), false);
			String pathDestination =  folderNode.getPath() 
					+ workspace.getPathSeparator() + Text.escapeIllegalJcrChars(name);

			try {
				servlets.copy(attachment.getPath(), pathDestination);
			} catch (HttpException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (IOException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}

			//Save the new name to attachment node, useful at the method getUniqueName()
			ItemDelegate itemSaved = servlets.getItemByPath(pathDestination);
			itemSaved.setOwner(workspace.getOwner().getPortalLogin());
			itemSaved.setTitle(name);

			//every download creates a new copy
			//copy all remote content item child nodes.
			workspace.copyRemoteContent(servlets, itemSaved,folderNode);

			servlets.saveItem(itemSaved);	


			return workspace.getItem(itemSaved.getId());
		} catch (org.gcube.common.homelibrary.model.exceptions.RepositoryException | RemoteBackendException e) {
			throw new InternalErrorException(e);
		} finally {
			servlets.releaseSession();
		} 
	}

	@Override
	public List<WorkspaceItem> getAttachments() throws InternalErrorException {

		List<WorkspaceItem> list = new LinkedList<WorkspaceItem>();
		try {

			@SuppressWarnings("unchecked")
			List<String> attachs = (List<String>) new XStream().fromXML(messageItem.getProperties().get(NodeProperty.ATTACHMENTS));
			for(String id : attachs) {
				list.add(workspace.getItem(id));
			}
		} catch (Exception e) {
			throw new InternalErrorException(e);
		} 
		return list;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<String> getAddresses() {
		return (List<String>) new XStream().fromXML(messageItem.getProperties().get(NodeProperty.ADDRESSES));
	}

	public boolean isOpened() {
		return isOpened;
	}




}
