/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.util.MetaInfo;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRPDFFile
extends JCRFile {
    public JCRPDFFile(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRPDFFile(JCRWorkspace workspace, ItemDelegate delegate, InputStream is) throws InternalErrorException, RemoteBackendException, IOException {
        super(workspace, delegate, is);
    }

    public JCRPDFFile(JCRWorkspace workspace, ItemDelegate itemDelegate, String path, MetaInfo info) throws InternalErrorException {
        super(workspace, itemDelegate, path, info);
    }

    public FolderItemType getFolderItemType() {
        return FolderItemType.EXTERNAL_PDF_FILE;
    }

    public int getNumberOfPages() {
        int numberOfPages = 0;
        try {
            numberOfPages = (Integer)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.NUMBER_OF_PAGES));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return numberOfPages;
    }

    public String getVersion() {
        String version = null;
        try {
            version = (String)this.itemDelegate.getContent().get(NodeProperty.VERSION);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return version;
    }

    public String getAuthor() {
        String author = null;
        try {
            author = (String)this.itemDelegate.getContent().get(NodeProperty.AUTHOR);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return author;
    }

    public String getTitle() {
        String title = null;
        try {
            title = (String)this.itemDelegate.getContent().get(NodeProperty.PDF_TITLE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return title;
    }

    public String getProducer() {
        String title = null;
        try {
            title = (String)this.itemDelegate.getContent().get(NodeProperty.PRODUCER);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return title;
    }

    @Override
    public void updateInfo(JCRServlets servlets, MetaInfo info) throws InternalErrorException {
        super.updateInfo(servlets, info);
    }
}

