/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.homelibary.model.util.MemoryCache;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.home.JCRHome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRHomeManager
implements HomeManager {
    private Map<String, JCRUser> users = new LinkedHashMap<String, JCRUser>();
    private static long timeToLiveInSeconds = 3600L;
    private static long timerIntervalInSeconds = 7200L;
    private static int maxItems = 20;
    private static MemoryCache<String, Home> cache = new MemoryCache(timeToLiveInSeconds, timerIntervalInSeconds, maxItems);
    private HomeManagerFactory factory;
    private static Logger logger = LoggerFactory.getLogger(JCRHomeManager.class);

    public JCRHomeManager(HomeManagerFactory factory) {
        this.factory = factory;
    }

    public HomeManagerFactory getHomeManagerFactory() {
        return this.factory;
    }

    public List<User> getUsers() {
        return new LinkedList<User>(this.users.values());
    }

    public User getUser(String portalLogin) throws InternalErrorException {
        logger.info("getUser portalLogin: " + portalLogin);
        return this.createUser(portalLogin);
    }

    public synchronized boolean existUser(String portalLogin) throws InternalErrorException {
        logger.trace("existUser portalLogin: " + portalLogin);
        if (portalLogin == null) {
            logger.error("portalLogin null");
            throw new IllegalArgumentException("The portalLogin value is null");
        }
        return this.users.containsKey(portalLogin);
    }

    public synchronized User createUser(String portalLogin) throws InternalErrorException {
        JCRUser user = this.users.get(portalLogin);
        if (user == null) {
            logger.info("User " + portalLogin + " not found, creating a new one.");
            user = new JCRUser(UUID.randomUUID().toString(), portalLogin);
            try {
                this.getHome(user);
            }
            catch (Exception e) {
                logger.error("error creating home", (Throwable)e);
            }
            logger.info("User created: " + user.getPortalLogin());
            this.users.put(portalLogin, user);
        }
        return user;
    }

    public Home getHome(User user) throws InternalErrorException, HomeNotFoundException {
        JCRHome home;
        logger.info("getHome user: " + user.getPortalLogin());
        logger.debug("List homes in cache...");
        for (String key : cache.keySet()) {
            logger.info(String.valueOf(key) + "'s home");
        }
        if (cache.containsKey((Object)user.getPortalLogin())) {
            logger.debug("User is already logged");
            home = (Home)cache.get((Object)user.getPortalLogin());
            return home;
        }
        try {
            home = new JCRHome(this, (JCRUser)user);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        logger.debug("Add " + user.getPortalLogin() + "'s home to memory cache");
        cache.put((Object)user.getPortalLogin(), (Object)home);
        logger.trace("User loaded.");
        return home;
    }

    public Home getHome(String portalLogin) throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        logger.info("getHome portalLogin: " + portalLogin);
        User user = this.getUser(portalLogin);
        return this.getHome(user);
    }

    public synchronized void removeUser(User user) throws InternalErrorException {
        cache.remove((Object)user.getPortalLogin());
    }

    public MemoryCache<String, Home> getCache() throws InternalErrorException {
        return cache;
    }

    public /* synthetic */ Home getHome() throws InternalErrorException, HomeNotFoundException, UserNotFoundException {
        throw new Error("Unresolved compilation problem: \n\tThe type JCRHomeManager must implement the inherited abstract method HomeManager.getHome()\n");
    }
}

